/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.component.model.payment.vo.PaymentChannelRegisterVO;
import com.ec.primus.component.service.payment.service.PaymentChannelService;
import com.ec.primus.component.service.payment.service.PaymentService;
import com.ec.primus.component.service.payment.service.TradeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentChannelRegister {
    private static final Logger logger = LoggerFactory.getLogger(PaymentChannelRegister.class);
    private final PaymentChannelService paymentChannelService;
    private final TradeTypeService tradeTypeService;
    private final PaymentService paymentService;

    @Autowired
    public PaymentChannelRegister(PaymentChannelService paymentChannelService, TradeTypeService tradeTypeService, PaymentService paymentService) {
        this.paymentChannelService = paymentChannelService;
        this.tradeTypeService = tradeTypeService;
        this.paymentService = paymentService;
    }

    public void register(PaymentChannelRegisterVO reqVO) {
        if (reqVO == null) {
            throw new IllegalArgumentException("Argument PaymentChannelRegisterVO can not be null.");
        }
        this.paymentChannelService.register(reqVO.getPaymentChannel());
        this.tradeTypeService.register(reqVO.getTradeTypes());
        this.paymentService.register(reqVO.getPaymentChannel(), reqVO.getPaymentServiceComponent());
    }
}

