/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.vo.IPaymentChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PaymentChannelService {
    private static final ConcurrentHashMap<String, IPaymentChannel> SUPPORTED_PAYMENT_CHANNELS = new ConcurrentHashMap();

    public Collection<IPaymentChannel> listSupportedPaymentChannels() {
        return SUPPORTED_PAYMENT_CHANNELS.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(IPaymentChannel paymentChannel) {
        if (paymentChannel == null || StringUtils.isBlank((CharSequence)paymentChannel.getIdentity()) || StringUtils.isBlank((CharSequence)paymentChannel.getName())) {
            throw new BusinessSilentException((ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, "Illegal MerchantTradeConfiguration, identity and name can not be blank.");
        }
        ConcurrentHashMap<String, IPaymentChannel> concurrentHashMap = SUPPORTED_PAYMENT_CHANNELS;
        synchronized (concurrentHashMap) {
            if (SUPPORTED_PAYMENT_CHANNELS.containsKey(paymentChannel.getIdentity())) {
                throw new BusinessSilentException((ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, "Payment channel:{} already registered.");
            }
            SUPPORTED_PAYMENT_CHANNELS.put(paymentChannel.getIdentity(), paymentChannel);
        }
    }
}

