/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentOrderExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderFindAllReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderGetReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderVO;
import com.ec.primus.component.service.base.service.AbstractComponentService;
import com.ec.primus.component.service.payment.dao.po.PaymentOrder;
import com.ec.primus.component.service.payment.dao.repository.PaymentOrderRepository;
import com.ec.primus.component.service.payment.dao.specification.PaymentOrderFindAllReqVOToPaymentOrderVO;
import com.ec.primus.component.service.payment.transfer.PaymentOrderToPaymentOrderVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentOrderService
extends AbstractComponentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentOrderService.class);
    private final PaymentOrderRepository repository;

    @Autowired
    public PaymentOrderService(PaymentOrderRepository repository) {
        this.repository = repository;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public PaymentOrder create(PaymentOrderCreateReqVO reqVo) {
        AssertUtils.notNull((Object)reqVo, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVo is null.");
        PaymentOrder target = new PaymentOrder();
        BeanUtils.copyProperties((Object)reqVo, (Object)((Object)target));
        target.setId(this.nextStringId());
        return (PaymentOrder)((Object)this.repository.save((Object)target));
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindTradeNo(String paymentOrderId, String tradeNo) {
        AssertUtils.notNull((Object)paymentOrderId, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVo is null.");
        AssertUtils.hasText((String)tradeNo, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVo is null.");
        this.repository.bindTradeNo(paymentOrderId, tradeNo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void discardAllPaymentOrderIfNotPaid(String mchId, String mchOrderNo) {
        this.repository.makeExistPaymentOrderToDiscardIfNotPaid(mchId, mchOrderNo, PaymentStatusEnum.DISCARD, PaymentStatusEnum.CREATE_PAYMENT);
    }

    List<PaymentOrder> findPaymentOrder(String mchId, String mchOrderNo) {
        AssertUtils.notNull((Object)mchId, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument mchId is null.");
        AssertUtils.notNull((Object)mchOrderNo, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument mchOrderNo is null.");
        return this.repository.findByMchIdAndMchOrderNoOrderByCreateTimeDesc(mchId, mchOrderNo);
    }

    PaymentOrder findLatestPaymentOrder(String mchId, String mchOrderNo) {
        List<PaymentOrder> paymentOrders = this.findPaymentOrder(mchId, mchOrderNo);
        AssertUtils.notEmpty(paymentOrders, (ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_NOT_FOUND, (String)String.format("PaymentOrder not found by mchId:[%s] and mchOrderNo:[%s]", mchId, mchOrderNo));
        return paymentOrders.get(0);
    }

    public PaymentOrderVO findPaymentOrder(PaymentOrderGetReqVO reqVO) {
        PaymentOrder latestPaymentOrder = this.findLatestPaymentOrder(reqVO.getMchId(), reqVO.getMchOrderNo());
        return new PaymentOrderToPaymentOrderVO().apply(latestPaymentOrder);
    }

    public PageResultVO<PaymentOrderVO> findPaymentOrders(PaymentOrderFindAllReqVO reqVO) {
        PageRequest pageRequest = reqVO.toPageRequest();
        PageRequest sortablePageRequest = new PageRequest(pageRequest.getPageNumber(), pageRequest.getPageSize(), new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "id")}));
        Page paymentOrderPage = this.repository.findAll((Specification)new PaymentOrderFindAllReqVOToPaymentOrderVO(reqVO), (Pageable)sortablePageRequest);
        return PageResultVO.ofPages((Page)paymentOrderPage, (Function)new PaymentOrderToPaymentOrderVO());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void markPaymentOrderPaymentStatusToPaid(String paymentOrderId, String tradeNo, Timestamp paySuccessTime, String payAccount) {
        log.debug("Confirm paymentOrder:'{}' status to paid with tradeNo:'{}' paySuccessTime:'{}' payAccount:'{}'", new Object[]{paymentOrderId, tradeNo, paySuccessTime, payAccount});
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tradeNo), (ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_NOT_FOUND, (String)"Argument tradeNo is blank");
        Integer affectedRow = this.repository.confirmPaid(paymentOrderId, tradeNo, paySuccessTime, payAccount);
        if (affectedRow == 0) {
            throw new BusinessSilentException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_NOT_PAYABLE, "Order status is not support to pay.");
        }
    }

    PaymentOrder findOne(String id) {
        AssertUtils.notNull((Object)id, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument id null.");
        PaymentOrder paymentOrder = (PaymentOrder)((Object)this.repository.findOne((Serializable)((Object)id)));
        AssertUtils.notNull((Object)((Object)paymentOrder), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)String.format("PaymentOrder not found by id:[%s]", id));
        return paymentOrder;
    }

    public PaymentOrder update(PaymentOrder paymentOrder) {
        AssertUtils.notNull((Object)((Object)paymentOrder), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"\u652f\u4ed8\u5355\u4e0d\u5b58\u5728");
        return (PaymentOrder)((Object)this.repository.save((Object)paymentOrder));
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveRefundRequestNo(PaymentOrderRefundReqVO reqVo) {
        AssertUtils.notNull((Object)reqVo, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"\u652f\u4ed8\u5355\u4e0d\u5b58\u5728");
        PaymentOrder paymentOrder = reqVo.getPaymentOrderId() == null ? this.findLatestPaymentOrder(reqVo.getMchId(), reqVo.getMchOrderNo()) : this.findOne(reqVo.getPaymentOrderId());
        if (!paymentOrder.getRefundRequestNo().contains(reqVo.getRefundNo())) {
            paymentOrder.getRefundRequestNo().add(reqVo.getRefundNo());
        }
        this.repository.save((Object)paymentOrder);
    }
}

