/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.commons.utils.JsonUtils;
import com.ec.primus.commons.utils.bean.CopyUtils;
import com.ec.primus.component.model.base.exception.BizBusinessException;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentNotifyTypeEnum;
import com.ec.primus.component.model.payment.enums.PaymentOrderExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import com.ec.primus.component.model.payment.service.IPaymentServiceComponent;
import com.ec.primus.component.model.payment.vo.IPaymentChannel;
import com.ec.primus.component.model.payment.vo.paymentorder.CommonPaidRespVo;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCloseReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentStatusCheckRespVO;
import com.ec.primus.component.service.payment.dao.po.PaymentOrder;
import com.ec.primus.component.service.payment.exception.PaymentOrderIsExpiredException;
import com.ec.primus.component.service.payment.exception.PaymentOrderIsPaidException;
import com.ec.primus.component.service.payment.service.PaymentOrderNotifyLogService;
import com.ec.primus.component.service.payment.service.PaymentOrderService;
import com.ec.primus.component.service.payment.service.TradeTypeService;
import com.ec.primus.component.service.payment.service.component.alipay.config.AlipayTradeType;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private static final ConcurrentHashMap<String, IPaymentServiceComponent> SUPPORTED_TRADE_TYPES = new ConcurrentHashMap();
    private final TradeTypeService tradeTypeService;
    private final PaymentOrderService paymentOrderService;
    private final PaymentOrderNotifyLogService paymentOrderNotifyLogService;

    @Autowired
    public PaymentService(TradeTypeService tradeTypeService, PaymentOrderService paymentOrderService, PaymentOrderNotifyLogService paymentOrderNotifyLogService) {
        this.tradeTypeService = tradeTypeService;
        this.paymentOrderService = paymentOrderService;
        this.paymentOrderNotifyLogService = paymentOrderNotifyLogService;
    }

    void register(IPaymentChannel paymentChannel, IPaymentServiceComponent paymentServiceComponent) {
        AssertUtils.notNull((Object)paymentChannel, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument paymentChannel is null");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)paymentChannel.getIdentity()), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument paymentChannel.identity is blank");
        SUPPORTED_TRADE_TYPES.put(paymentChannel.getIdentity(), paymentServiceComponent);
    }

    public PaymentOrderCreateRespVO createPaymentOrder(PaymentOrderCreateReqVO reqVO) throws PaymentOrderIsExpiredException, PaymentOrderIsPaidException, BizBusinessException {
        log.info("Create PaymentOrder for {}", (Object)reqVO);
        AssertUtils.notNull((Object)reqVO, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null");
        AssertUtils.notNull((Object)reqVO.getExpireTime(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.expireTime is null");
        if (reqVO.getExpireTime() == null || reqVO.getExpireTime().getTime() < System.currentTimeMillis()) {
            throw new PaymentOrderIsExpiredException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_EXPIRED, "Order is expired.");
        }
        IPaymentServiceComponent paymentServiceComponent = this.getPaymentServiceComponent(reqVO.getPaymentChannel());
        this.validateExistPaymentOrderPaymentStatusAndDiscardNotPaid(reqVO.getMchId(), reqVO.getMchOrderNo());
        String tradeTypeConfigurationByMerchantAndTradeType = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(reqVO.getMchId(), reqVO.getPaymentChannel(), reqVO.getTradeType());
        PaymentOrder paymentOrder = this.paymentOrderService.create(reqVO);
        Object paymentSdkParameters = paymentServiceComponent.createPayment(tradeTypeConfigurationByMerchantAndTradeType, reqVO);
        PaymentOrderCreateRespVO respVO = new PaymentOrderCreateRespVO();
        respVO.setId(paymentOrder.getId());
        respVO.setMchId(paymentOrder.getMchId());
        respVO.setMchOrderNo(paymentOrder.getMchOrderNo());
        respVO.setPaymentSdkParametersJson(AlipayTradeType.ALIPAY_PC.name().equals(reqVO.getTradeType()) ? paymentSdkParameters.toString() : JsonUtils.obj2Json((Object)paymentSdkParameters));
        return respVO;
    }

    @Transactional(propagation=Propagation.NEVER)
    public PaymentStatusCheckRespVO checkPaymentStatus(String id, String mchId, String mchOrderNO) throws BizBusinessException {
        CommonPaidRespVo commonPaidRespVo;
        log.info("Check payment status for id:{}, mchId:{}, mchOrderNO:{}", new Object[]{id, mchId, mchOrderNO});
        PaymentOrder paymentOrder = this.getPaymentOrder(id, mchId, mchOrderNO);
        AssertUtils.notNull((Object)((Object)paymentOrder), (ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_NOT_FOUND, (String)"payment order not found");
        if (paymentOrder.getPaymentStatus() == PaymentStatusEnum.CREATE_PAYMENT && (commonPaidRespVo = this.isPaid(paymentOrder)).getPaid().booleanValue()) {
            paymentOrder.setPaymentStatus(PaymentStatusEnum.PAID);
            paymentOrder.setPayAccount(commonPaidRespVo.getPayAccount());
            paymentOrder.setTradeNo(commonPaidRespVo.getTradeNo());
            paymentOrder.setPaySuccessTime(this.confirmPaid(paymentOrder.getId(), commonPaidRespVo.getTradeNo(), commonPaidRespVo.getPaidTime(), commonPaidRespVo.getPayAccount()));
        }
        PaymentStatusCheckRespVO respVO = new PaymentStatusCheckRespVO();
        CopyUtils.copyProperties((Object)((Object)paymentOrder), (Object)respVO);
        respVO.setMchId(paymentOrder.getMchId());
        respVO.setPayAccount(StringUtils.isNotBlank((CharSequence)paymentOrder.getPayAccount()) ? paymentOrder.getPayAccount() : "");
        respVO.setTradeNo(paymentOrder.getTradeNo());
        respVO.setRefundRequestNo(paymentOrder.getRefundRequestNo());
        return respVO;
    }

    public PaymentOrderRefundRespVO refund(PaymentOrderRefundReqVO reqVO) throws BizBusinessException {
        AssertUtils.notNull((Object)reqVO, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null");
        log.info("Refund payment for {}, origin mchOrderNo:{}", (Object)reqVO, (Object)reqVO.getMchOrderNo());
        PaymentStatusCheckRespVO paymentQueryRespVo = this.checkPaymentStatus(reqVO.getPaymentOrderId(), reqVO.getMchId(), reqVO.getMchOrderNo());
        if (paymentQueryRespVo.getPaymentStatus() == PaymentStatusEnum.PAID) {
            boolean thirdRefundSuccess;
            IPaymentServiceComponent paymentServiceComponent = this.getPaymentServiceComponent(paymentQueryRespVo.getPaymentChannel());
            String tradeTypeConfiguration = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(reqVO.getMchId(), paymentQueryRespVo.getPaymentChannel(), paymentQueryRespVo.getTradeType());
            PaymentOrderRefundRespVO paymentRefundRespVo = paymentServiceComponent.refund(tradeTypeConfiguration, reqVO);
            paymentRefundRespVo.setOutRefundNo(reqVO.getRefundNo());
            boolean bl = thirdRefundSuccess = Boolean.TRUE.equals(paymentRefundRespVo.getRefundApplySuccess()) || Boolean.TRUE.equals(paymentRefundRespVo.getRefundSuccess());
            if (thirdRefundSuccess && StringUtils.isNotBlank((CharSequence)paymentRefundRespVo.getRefundTradeNo())) {
                this.paymentOrderService.saveRefundRequestNo(reqVO);
            }
            return paymentRefundRespVo;
        }
        throw new BusinessSilentException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_NOT_PAID, "Order not paid.");
    }

    public PaymentOrderRefundStatusCheckRespVO checkRefundStatus(PaymentOrderRefundStatusCheckReqVO reqVO) throws BizBusinessException {
        PaymentStatusCheckRespVO paymentStatusCheckRespVO = this.checkPaymentStatus(reqVO.getPaymentOrderId(), reqVO.getMchId(), reqVO.getMchOrderNo());
        IPaymentServiceComponent paymentServiceComponent = this.getPaymentServiceComponent(paymentStatusCheckRespVO.getPaymentChannel());
        String tradeTypeConfiguration = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(reqVO.getMchId(), paymentStatusCheckRespVO.getPaymentChannel(), paymentStatusCheckRespVO.getTradeType());
        log.info("Query refund status for merchant:{} mchOrderNo:{}", (Object)paymentStatusCheckRespVO.getMchId(), (Object)paymentStatusCheckRespVO.getMchOrderNo());
        PaymentOrderRefundStatusCheckRespVO paymentOrderRefundStatusCheckRespVO = paymentServiceComponent.refundQuery(tradeTypeConfiguration, paymentStatusCheckRespVO.getMchOrderNo(), paymentStatusCheckRespVO.getRefundRequestNo());
        paymentOrderRefundStatusCheckRespVO.setPaymentOrderId(paymentStatusCheckRespVO.getId());
        paymentOrderRefundStatusCheckRespVO.setMchId(paymentStatusCheckRespVO.getMchId());
        paymentOrderRefundStatusCheckRespVO.setMchOrderNo(paymentStatusCheckRespVO.getMchOrderNo());
        return paymentOrderRefundStatusCheckRespVO;
    }

    public void close(PaymentOrderCloseReqVO reqVO) throws PaymentOrderIsPaidException, BizBusinessException {
        log.info("Close payment for {}", (Object)reqVO);
        this.validateExistPaymentOrderPaymentStatusAndDiscardNotPaid(reqVO.getMchId(), reqVO.getMchOrderNo());
    }

    public void handleNotify(PaymentNotifyTypeEnum notifyType, String paymentChannel, String notifyData) throws BizBusinessException {
        AssertUtils.notNull((Object)paymentChannel, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument paymentChannel is null");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)notifyData), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument notifyData is blank");
        this.paymentOrderNotifyLogService.recordNotifyLog(paymentChannel, notifyData);
        IPaymentServiceComponent paymentServiceComponent = this.getPaymentServiceComponent(paymentChannel);
        switch (notifyType) {
            case PAY: {
                String tradeTypeConfigurationJson;
                PaymentPayNotifyValidateResultVO paymentPayNotifyValidateResultVO;
                PaymentPayNotifyParseResultVO paymentPayNotifyParseResultVO = paymentServiceComponent.parsePayNotify(notifyData);
                PaymentOrder paymentOrder = this.paymentOrderService.findLatestPaymentOrder(paymentPayNotifyParseResultVO.getMchId(), paymentPayNotifyParseResultVO.getMchOrderNo());
                if (paymentOrder == null || paymentOrder.getPaymentStatus() != PaymentStatusEnum.CREATE_PAYMENT || !(paymentPayNotifyValidateResultVO = paymentServiceComponent.validatePayNotify(tradeTypeConfigurationJson = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(paymentOrder.getMchId(), paymentOrder.getPaymentChannel(), paymentOrder.getTradeType()), notifyData)).getIsPaid().booleanValue()) break;
                this.confirmPaid(paymentOrder.getId(), paymentPayNotifyValidateResultVO.getTradeNO(), paymentPayNotifyValidateResultVO.getPaidTime(), paymentPayNotifyValidateResultVO.getPayAccount());
                break;
            }
            case REFUND: {
                String tradeTypeConfigurationJson;
                PaymentRefundNotifyValidateResultVO paymentRefundNotifyValidateResultVO;
                PaymentRefundNotifyParseResultVO paymentRefundNotifyParseResultVO = paymentServiceComponent.parseRefundNotify(notifyData);
                PaymentOrder paymentOrder = this.paymentOrderService.findLatestPaymentOrder(paymentRefundNotifyParseResultVO.getMchId(), paymentRefundNotifyParseResultVO.getMchOrderNo());
                if (paymentOrder == null || !(paymentRefundNotifyValidateResultVO = paymentServiceComponent.validateRefundNotify(tradeTypeConfigurationJson = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(paymentOrder.getMchId(), paymentOrder.getPaymentChannel(), paymentOrder.getTradeType()), notifyData)).getIsRefund().booleanValue()) break;
                this.confirmRefund(paymentOrder.getId(), paymentRefundNotifyValidateResultVO.getMchRefundNO(), paymentRefundNotifyValidateResultVO.getTradeNO());
                break;
            }
            default: {
                throw new BusinessSilentException((ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, "PaymentNotifyType is illegal.");
            }
        }
    }

    private IPaymentServiceComponent getPaymentServiceComponent(String paymentChannelIdentity) {
        IPaymentServiceComponent paymentServiceComponent = SUPPORTED_TRADE_TYPES.get(paymentChannelIdentity);
        AssertUtils.notNull((Object)paymentServiceComponent, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)("Payment channel:" + paymentChannelIdentity + " not register."));
        return paymentServiceComponent;
    }

    private PaymentOrder getPaymentOrder(String id, String mchId, String mchOrderNO) {
        PaymentOrder paymentOrder = id == null ? this.paymentOrderService.findLatestPaymentOrder(mchId, mchOrderNO) : this.paymentOrderService.findOne(id);
        return paymentOrder;
    }

    private void validateExistPaymentOrderPaymentStatusAndDiscardNotPaid(String mchId, String mchOrderNo) throws PaymentOrderIsPaidException, BizBusinessException {
        List<PaymentOrder> existPaymentOrders = this.paymentOrderService.findPaymentOrder(mchId, mchOrderNo);
        if (CollectionUtils.isNotEmpty(existPaymentOrders)) {
            log.info("Validate Payment order {} payment status, and discard them.", existPaymentOrders);
            Boolean needDiscardPayment = false;
            block8: for (PaymentOrder existPaymentOrder : existPaymentOrders) {
                switch (existPaymentOrder.getPaymentStatus()) {
                    case DISCARD: {
                        continue block8;
                    }
                    case CREATE_PAYMENT: {
                        CommonPaidRespVo commonPaidRespVo = this.isPaid(existPaymentOrder);
                        if (commonPaidRespVo.getPaid().booleanValue()) {
                            this.confirmPaid(existPaymentOrder.getId(), commonPaidRespVo.getTradeNo(), commonPaidRespVo.getPaidTime(), commonPaidRespVo.getPayAccount());
                            throw new PaymentOrderIsPaidException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_PAID, String.format("Order was paid by PaymentOrder:[%s]", existPaymentOrder.getId()));
                        }
                        needDiscardPayment = true;
                        continue block8;
                    }
                    case PAID: {
                        throw new PaymentOrderIsPaidException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_PAID, String.format("Order is paid by PaymentOrder:[%s]", existPaymentOrder.getId()));
                    }
                    case REFUNDING: {
                        throw new PaymentOrderIsPaidException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_REFUNDED, String.format("Order is refunding by PaymentOrder:[%s]", existPaymentOrder.getId()));
                    }
                    case REFUNDED: {
                        throw new PaymentOrderIsPaidException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_REFUNDED, String.format("Order is refunded by PaymentOrder:[%s]", existPaymentOrder.getId()));
                    }
                    case REFUND_FAILED: {
                        throw new PaymentOrderIsPaidException((ExceptionType)PaymentOrderExceptionEnum.PAYMENT_ORDER_IS_REFUNDED, String.format("Order is refund failed by PaymentOrder:[%s]", existPaymentOrder.getId()));
                    }
                }
                throw new BusinessSilentException((ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, String.format("Illegal PaymentStatus:[%s] of PaymentOrder:[%s]", existPaymentOrder.getPaymentStatus(), existPaymentOrder.getId()));
            }
            if (needDiscardPayment.booleanValue()) {
                this.paymentOrderService.discardAllPaymentOrderIfNotPaid(mchId, mchOrderNo);
            }
        }
    }

    private CommonPaidRespVo isPaid(PaymentOrder paymentOrder) throws BizBusinessException {
        log.info("Query Payment order {} payment status", (Object)paymentOrder);
        IPaymentServiceComponent paymentServiceComponent = this.getPaymentServiceComponent(paymentOrder.getPaymentChannel());
        String tradeTypeConfiguration = this.tradeTypeService.findTradeTypeConfigurationByMerchantAndTradeType(paymentOrder.getMchId(), paymentOrder.getPaymentChannel(), paymentOrder.getTradeType());
        return paymentServiceComponent.isPad(tradeTypeConfiguration, paymentOrder.getTradeNo(), paymentOrder.getMchOrderNo());
    }

    private Timestamp confirmPaid(String paymentOrderId, String tradeNo, Date paidTime, String payAccount) {
        Timestamp paySuccessTime = paidTime == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(paidTime.getTime());
        this.paymentOrderService.markPaymentOrderPaymentStatusToPaid(paymentOrderId, tradeNo, paySuccessTime, payAccount);
        return paySuccessTime;
    }

    private void confirmRefund(String paymentOrderId, String mchRefundNO, String tradeNo) {
    }
}

