/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.base.exception.BizBusinessException;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.enums.TradeTypeExceptionEnum;
import com.ec.primus.component.model.payment.vo.ITradeType;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationFindAllByMerchantReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationFindAllReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationGetReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationUpdateReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeEnableListReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeUserAccountInfoQueryReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeUserAccountInfoQueryRespVO;
import com.ec.primus.component.service.base.service.AbstractComponentService;
import com.ec.primus.component.service.payment.dao.po.Merchant;
import com.ec.primus.component.service.payment.dao.po.MerchantTradeConfiguration;
import com.ec.primus.component.service.payment.dao.repository.MerchantTradeConfigurationRepository;
import com.ec.primus.component.service.payment.dao.specification.TradeTypeConfigurationFindAllReqVOToSpecification;
import com.ec.primus.component.service.payment.service.MerchantService;
import com.ec.primus.component.service.payment.transfer.MerchantTradeConfigurationToTradeTypeConfigurationVO;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TradeTypeService
extends AbstractComponentService {
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, ITradeType>> SUPPORTED_TRADE_TYPES = new ConcurrentHashMap();
    private final MerchantTradeConfigurationRepository merchantTradeConfigurationRepository;
    private final MerchantService merchantService;

    @Autowired
    public TradeTypeService(MerchantTradeConfigurationRepository merchantTradeConfigurationRepository, MerchantService merchantService) {
        this.merchantTradeConfigurationRepository = merchantTradeConfigurationRepository;
        this.merchantService = merchantService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Collection<ITradeType> iTradeTypes) {
        AssertUtils.notEmpty(iTradeTypes, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Illegal TradeTypes, TradeTypes can not be empty.");
        ConcurrentHashMap<String, ConcurrentHashMap<String, ITradeType>> concurrentHashMap = SUPPORTED_TRADE_TYPES;
        synchronized (concurrentHashMap) {
            for (ITradeType iTradeType : iTradeTypes) {
                ConcurrentHashMap tradeTypesMapOfChannel = SUPPORTED_TRADE_TYPES.computeIfAbsent(iTradeType.getPaymentChannel().getIdentity(), k -> new ConcurrentHashMap(1));
                tradeTypesMapOfChannel.put(iTradeType.getIdentity(), iTradeType);
            }
        }
    }

    public void setup() {
    }

    public Collection<ITradeType> listSupportedAndEnableITradeTypes(TradeTypeEnableListReqVO reqVO) {
        Collection<ConcurrentHashMap<String, ITradeType>> values = SUPPORTED_TRADE_TYPES.values();
        ArrayList supportedTradeTypes = Lists.newArrayList();
        List<MerchantTradeConfiguration> merchantTradeConfigurations = this.merchantTradeConfigurationRepository.findByMchIdAndStatusAndDeleteFlag(reqVO.getMchId(), reqVO.getStatus(), false);
        if (CollectionUtils.isNotEmpty(merchantTradeConfigurations)) {
            Map<String, MerchantTradeConfiguration> tradeConfigurationMap = merchantTradeConfigurations.stream().collect(Collectors.toMap(MerchantTradeConfiguration::getTradeType, t -> t, (key1, key2) -> key1));
            for (ConcurrentHashMap<String, ITradeType> value : values) {
                value.values().forEach(iTradeType -> {
                    if (tradeConfigurationMap.get(iTradeType.getIdentity()) != null) {
                        supportedTradeTypes.add(iTradeType);
                    }
                });
            }
        }
        return supportedTradeTypes;
    }

    public Collection<ITradeType> listSupportedTradeTypes() {
        Collection<ConcurrentHashMap<String, ITradeType>> values = SUPPORTED_TRADE_TYPES.values();
        ArrayList supportedTradeTypes = Lists.newArrayList();
        for (ConcurrentHashMap<String, ITradeType> value : values) {
            supportedTradeTypes.addAll(value.values());
        }
        return supportedTradeTypes;
    }

    public TradeTypeConfigurationVO updateMerchantTradeTypeConfiguration(TradeTypeConfigurationUpdateReqVO reqVO) {
        AssertUtils.notNull((Object)reqVO.getMchId(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.mchId is null.");
        AssertUtils.notNull((Object)reqVO.getPaymentChannel(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.paymentChannel is null.");
        AssertUtils.notNull((Object)reqVO.getTradeType(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.tradeType is null.");
        MerchantTradeConfiguration merchantTradeConfiguration = this.merchantTradeConfigurationRepository.findByMchIdAndPaymentChannelAndTradeType(reqVO.getMchId(), reqVO.getPaymentChannel(), reqVO.getTradeType());
        if (merchantTradeConfiguration == null) {
            Merchant merchant = this.merchantService.findOne(reqVO.getMchId());
            merchantTradeConfiguration = new MerchantTradeConfiguration();
            merchantTradeConfiguration.setMchId(merchant.getId());
            merchantTradeConfiguration.setId(this.nextId().toString());
        }
        BeanUtils.copyProperties((Object)reqVO, (Object)merchantTradeConfiguration);
        MerchantTradeConfiguration savedMerchantTradeTypeConfiguration = (MerchantTradeConfiguration)this.merchantTradeConfigurationRepository.save(merchantTradeConfiguration);
        return new MerchantTradeConfigurationToTradeTypeConfigurationVO().apply(savedMerchantTradeTypeConfiguration);
    }

    public TradeTypeConfigurationVO getTradeTypeConfiguration(TradeTypeConfigurationGetReqVO reqVO) throws BizBusinessException {
        AssertUtils.notNull((Object)reqVO.getId(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.id is null.");
        MerchantTradeConfiguration existMerchantTradeConfiguration = this.merchantTradeConfigurationRepository.findByIdAndDeleteFlag(reqVO.getId(), Boolean.FALSE);
        if (existMerchantTradeConfiguration == null) {
            throw new BizBusinessException((ExceptionType)TradeTypeExceptionEnum.MERCHANT_TRADE_CONFIGURATION_NOT_FOUND);
        }
        return new MerchantTradeConfigurationToTradeTypeConfigurationVO().apply(existMerchantTradeConfiguration);
    }

    public List<TradeTypeConfigurationVO> findAllTradeTypeConfigurationsByMerchantId(TradeTypeConfigurationFindAllByMerchantReqVO reqVO) {
        AssertUtils.notNull((Object)reqVO.getMchId(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.mchId is null.");
        List<MerchantTradeConfiguration> merchantTradeConfigurationByMerchant = this.merchantTradeConfigurationRepository.findByMchIdAndDeleteFlag(reqVO.getMchId(), Boolean.FALSE);
        merchantTradeConfigurationByMerchant.sort((o1, o2) -> ComparisonChain.start().compare((Object)o1.getPaymentChannel(), (Object)o2.getPaymentChannel(), (Comparator)Ordering.natural().nullsLast()).compare((Object)o1.getTradeType(), (Object)o2.getTradeType(), (Comparator)Ordering.natural().nullsLast()).result());
        return merchantTradeConfigurationByMerchant.stream().map(new MerchantTradeConfigurationToTradeTypeConfigurationVO()).collect(Collectors.toList());
    }

    public PageResultVO<TradeTypeConfigurationVO> findAllTradeTypeConfigurations(TradeTypeConfigurationFindAllReqVO reqVO) {
        PageRequest pageRequest = reqVO.toPageRequest();
        PageRequest sortablePageRequest = new PageRequest(pageRequest.getPageNumber(), pageRequest.getPageSize(), new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "id")}));
        Page merchantPage = this.merchantTradeConfigurationRepository.findAll((Specification)new TradeTypeConfigurationFindAllReqVOToSpecification(reqVO), (Pageable)sortablePageRequest);
        return PageResultVO.ofPages((Page)merchantPage, (Function)new MerchantTradeConfigurationToTradeTypeConfigurationVO());
    }

    public TradeTypeUserAccountInfoQueryRespVO tradeTypeUserAccountInfoQuery(TradeTypeUserAccountInfoQueryReqVO reqVO) {
        return null;
    }

    String findTradeTypeConfigurationByMerchantAndTradeType(String mchId, String paymentChannel, String tradeType) throws BizBusinessException {
        MerchantTradeConfiguration merchantTradeConfiguration = this.merchantTradeConfigurationRepository.findByMchIdAndPaymentChannelAndTradeType(mchId, paymentChannel, tradeType);
        if (merchantTradeConfiguration == null || StringUtils.isBlank((CharSequence)merchantTradeConfiguration.getConfigurationJson())) {
            throw new BizBusinessException((ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, "\u5546\u6237\u4ea4\u6613\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e");
        }
        return merchantTradeConfiguration.getConfigurationJson();
    }
}

