/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.utils.JsonUtils;
import com.ec.primus.commons.utils.Stopwatch;
import com.ec.primus.commons.utils.StringUtil;
import com.ec.primus.component.model.payment.service.IPaymentServiceComponent;
import com.ec.primus.component.model.payment.vo.paymentorder.CommonPaidRespVo;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyValidateResultVO;
import com.ec.primus.component.service.payment.service.component.alipay.config.AlipayConfiguration;
import com.ec.primus.component.service.payment.service.component.alipay.config.AlipayGlobalConfiguration;
import com.ec.primus.component.service.payment.service.component.alipay.config.AlipayTradeType;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayPaymentServiceComponent
implements IPaymentServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(AlipayPaymentServiceComponent.class);
    private final AlipayGlobalConfiguration alipayGlobalConfiguration;

    @Autowired
    public AlipayPaymentServiceComponent(AlipayGlobalConfiguration alipayGlobalConfiguration) {
        this.alipayGlobalConfiguration = alipayGlobalConfiguration;
    }

    public Object createPayment(String tradeTypeConfigurationJson, PaymentOrderCreateReqVO reqVO) {
        AlipayConfiguration alipayConfiguration = this.parseConfiguration(tradeTypeConfigurationJson);
        AlipayTradeType reqTradeType = AlipayTradeType.valueOf(reqVO.getTradeType());
        switch (reqTradeType) {
            case ALIPAY_MOBILE: {
                return this.createMobilePayment(reqVO, alipayConfiguration);
            }
            case ALIPAY_WAP: {
                return this.createWapPayment(reqVO, alipayConfiguration);
            }
            case ALIPAY_NATIVE: {
                return this.createNativePayment(reqVO, alipayConfiguration);
            }
            case ALIPAY_PC: {
                return this.createPcPayment(reqVO, alipayConfiguration);
            }
        }
        throw new BusinessSilentException("Unsupported alipay trade type");
    }

    public CommonPaidRespVo isPad(String configJson, String tradeNo, String mchOrderNo) {
        if (StringUtils.isEmpty((CharSequence)tradeNo) && StringUtils.isBlank((CharSequence)mchOrderNo)) {
            throw new BusinessSilentException("tradeNo and mchOrderNo can not be both null.");
        }
        if (log.isDebugEnabled()) {
            log.debug("tradeNo--> {}", (Object)tradeNo);
            log.debug("mchOrderNo--> {}", (Object)mchOrderNo);
        }
        AlipayConfiguration alipayConfiguration = this.parseConfiguration(configJson);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        AlipayTradeQueryRequest alipayTradeQueryRequest = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setTradeNo(tradeNo);
        model.setOutTradeNo(mchOrderNo);
        alipayTradeQueryRequest.setBizModel((AlipayObject)model);
        try {
            AlipayTradeQueryResponse alipayTradeQueryResponse = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)alipayTradeQueryRequest);
            boolean isPaid = alipayTradeQueryResponse.isSuccess() && (StringUtils.equals((CharSequence)"TRADE_SUCCESS", (CharSequence)alipayTradeQueryResponse.getTradeStatus()) || StringUtils.equals((CharSequence)"TRADE_FINISHED", (CharSequence)alipayTradeQueryResponse.getTradeStatus()));
            return new CommonPaidRespVo(alipayTradeQueryResponse.getTradeNo(), Boolean.valueOf(isPaid), new Date(), alipayTradeQueryResponse.getBuyerLogonId());
        }
        catch (AlipayApiException e) {
            log.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u652f\u4ed8\u72b6\u6001\u5931\u8d25, partner:{}, appId:{}, signType:{}", new Object[]{alipayConfiguration.getPartner(), alipayConfiguration.getAppId(), alipayConfiguration.getSignType(), e});
            throw new BusinessSilentException("\u67e5\u8be2\u652f\u4ed8\u5b9d\u5355\u7b14\u4ea4\u6613\u5931\u8d25");
        }
    }

    public PaymentOrderRefundRespVO refund(String configurationJson, PaymentOrderRefundReqVO reqVO) {
        AlipayTradeRefundResponse result;
        AlipayConfiguration alipayConfiguration = this.parseConfiguration(configurationJson);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        Stopwatch timers = Stopwatch.createAndBegin((boolean)log.isDebugEnabled());
        try {
            AlipayTradeRefundRequest alipayTradeRefundRequest = new AlipayTradeRefundRequest();
            AlipayTradeRefundModel model = new AlipayTradeRefundModel();
            model.setOutTradeNo(reqVO.getMchOrderNo());
            model.setOutRequestNo(reqVO.getRefundNo());
            model.setRefundAmount(StringUtil.formatPriceToYuanWithFen((long)reqVO.getRefundAmount()));
            model.setRefundReason(reqVO.getRefundReason());
            alipayTradeRefundRequest.setNotifyUrl(alipayConfiguration.getRefundNotifyUrl());
            alipayTradeRefundRequest.setBizModel((AlipayObject)model);
            result = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)alipayTradeRefundRequest);
            log.debug("Alipay return: {} for refund:{}", (Object)result.getBody(), (Object)reqVO);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Got an exception from alipay refund.", (Throwable)e);
            }
            throw new BusinessSilentException("\u9000\u6b3e\u5931\u8d25");
        }
        timers.record("\u53d1\u8d77\u9000\u6b3e");
        timers.print("use time alipay refund");
        PaymentOrderRefundRespVO paymentRefundRespVo = new PaymentOrderRefundRespVO();
        paymentRefundRespVo.setRefundApplySuccess(Boolean.valueOf(result.isSuccess()));
        paymentRefundRespVo.setRefundSuccess(Boolean.valueOf(result.isSuccess()));
        paymentRefundRespVo.setRefundTradeNo(result.getTradeNo());
        return paymentRefundRespVo;
    }

    public PaymentOrderRefundStatusCheckRespVO refundQuery(String configurationJson, String mchOrderNo, List<String> refundRequestNos) {
        AlipayConfiguration alipayConfiguration = this.parseConfiguration(configurationJson);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        PaymentOrderRefundStatusCheckRespVO paymentOrderRefundStatusCheckRespVO = new PaymentOrderRefundStatusCheckRespVO();
        List queryResult = refundRequestNos.stream().map(arg_0 -> AlipayPaymentServiceComponent.lambda$refundQuery$0(mchOrderNo, alipayConfiguration, (AlipayClient)alipayClient, arg_0)).collect(Collectors.toList());
        paymentOrderRefundStatusCheckRespVO.setPaymentOrderRefundStatusVOs(queryResult);
        return paymentOrderRefundStatusCheckRespVO;
    }

    public PaymentPayNotifyParseResultVO parsePayNotify(String notifyData) {
        return null;
    }

    public PaymentPayNotifyValidateResultVO validatePayNotify(String configurationJson, String notifyData) {
        return null;
    }

    public PaymentRefundNotifyParseResultVO parseRefundNotify(String notifyData) {
        return null;
    }

    public PaymentRefundNotifyValidateResultVO validateRefundNotify(String configurationJson, String notifyData) {
        return null;
    }

    String createMobilePayment(PaymentOrderCreateReqVO paymentReqVo, AlipayConfiguration alipayConfiguration) {
        String params;
        Stopwatch timers = Stopwatch.createAndBegin((boolean)log.isDebugEnabled());
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "UTF-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        AlipayTradeAppPayRequest alipayTradeAppPayRequest = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setSubject(paymentReqVo.getSubject());
        model.setBody(paymentReqVo.getBody());
        model.setOutTradeNo(paymentReqVo.getMchOrderNo());
        long timeoutMillis = paymentReqVo.getExpireTime().getTime() - System.currentTimeMillis();
        long timeoutMinute = timeoutMillis / 1000L / 60L;
        model.setTimeoutExpress(String.format("%sm", timeoutMinute));
        model.setTotalAmount(StringUtil.formatPriceToYuanWithFen((long)paymentReqVo.getAmount()));
        alipayTradeAppPayRequest.setBizModel((AlipayObject)model);
        alipayTradeAppPayRequest.setNotifyUrl(alipayConfiguration.getNotifyUrl());
        try {
            AlipayTradeAppPayResponse execute = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)alipayTradeAppPayRequest);
            params = execute.getBody();
        }
        catch (AlipayApiException e) {
            if (log.isDebugEnabled()) {
                log.error("get alipay mobile pay request failed", (Throwable)e);
            }
            throw new BusinessSilentException("\u7b7e\u540d\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u8d77\u652f\u4ed8");
        }
        timers.record("\u8ba1\u7b97\u7b7e\u540d");
        timers.print("use time alipay-sign");
        return params;
    }

    String createPcPayment(PaymentOrderCreateReqVO paymentReqVo, AlipayConfiguration alipayConfiguration) {
        String params;
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        Stopwatch timers = Stopwatch.createAndBegin((boolean)log.isDebugEnabled());
        try {
            AlipayTradePagePayRequest alipayTradePagePayRequest = new AlipayTradePagePayRequest();
            AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
            model.setBody(paymentReqVo.getBody());
            model.setSubject(paymentReqVo.getSubject());
            model.setOutTradeNo(paymentReqVo.getMchOrderNo());
            model.setTimeoutExpress("30m");
            model.setTotalAmount(StringUtil.formatPriceToYuanWithFen((long)paymentReqVo.getAmount()));
            model.setProductCode("FAST_INSTANT_TRADE_PAY");
            model.setPassbackParams(paymentReqVo.getMchId());
            alipayTradePagePayRequest.setBizModel((AlipayObject)model);
            alipayTradePagePayRequest.setNotifyUrl(alipayConfiguration.getNotifyUrl());
            alipayTradePagePayRequest.setReturnUrl(alipayConfiguration.getReturnUrl());
            params = ((AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)alipayTradePagePayRequest)).getBody();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.error("get alipay mobile pay request params sign failed", e);
            }
            throw new BusinessSilentException("\u7b7e\u540d\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u8d77\u652f\u4ed8");
        }
        timers.record("\u8ba1\u7b97\u7b7e\u540d");
        timers.print("use time alipay-sign");
        return params;
    }

    String createWapPayment(PaymentOrderCreateReqVO paymentReqVo, AlipayConfiguration alipayConfiguration) {
        String params;
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        Stopwatch timers = Stopwatch.createAndBegin((boolean)log.isDebugEnabled());
        try {
            AlipayTradeWapPayRequest alipayTradeWapPayRequest = new AlipayTradeWapPayRequest();
            AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
            model.setBody(paymentReqVo.getBody());
            model.setSubject(paymentReqVo.getSubject());
            model.setOutTradeNo(paymentReqVo.getMchOrderNo());
            model.setTimeoutExpress("30m");
            model.setTotalAmount(StringUtil.formatPriceToYuanWithFen((long)paymentReqVo.getAmount()));
            model.setPassbackParams(paymentReqVo.getMchId());
            alipayTradeWapPayRequest.setBizModel((AlipayObject)model);
            alipayTradeWapPayRequest.setNotifyUrl(alipayConfiguration.getNotifyUrl());
            alipayTradeWapPayRequest.setReturnUrl(alipayConfiguration.getReturnUrl());
            params = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayTradeWapPayRequest)).getBody();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.error("get alipay mobile pay request params sign failed", e);
            }
            throw new BusinessSilentException("\u7b7e\u540d\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u8d77\u652f\u4ed8");
        }
        timers.record("\u8ba1\u7b97\u7b7e\u540d");
        timers.print("use time alipay-sign");
        return params;
    }

    String createNativePayment(PaymentOrderCreateReqVO paymentReqVo, AlipayConfiguration alipayConfiguration) {
        String params;
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfiguration.getAppId(), alipayConfiguration.getPrivateKey(), "json", "utf-8", alipayConfiguration.getAliPublicKey(), StringUtils.isBlank((CharSequence)alipayConfiguration.getSignType()) ? "RSA2" : alipayConfiguration.getSignType());
        Stopwatch timers = Stopwatch.createAndBegin((boolean)log.isDebugEnabled());
        try {
            AlipayTradePrecreateRequest alipayTradeWapPayRequest = new AlipayTradePrecreateRequest();
            AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
            model.setBody(paymentReqVo.getBody());
            model.setSubject(paymentReqVo.getSubject());
            model.setOutTradeNo(paymentReqVo.getMchOrderNo());
            model.setTimeoutExpress("30m");
            model.setTotalAmount(StringUtil.formatPriceToYuanWithFen((long)paymentReqVo.getAmount()));
            model.setPassbackParams(paymentReqVo.getMchId());
            alipayTradeWapPayRequest.setBizModel((AlipayObject)model);
            alipayTradeWapPayRequest.setNotifyUrl(alipayConfiguration.getNotifyUrl());
            alipayTradeWapPayRequest.setReturnUrl(alipayConfiguration.getReturnUrl());
            params = ((AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)alipayTradeWapPayRequest)).getBody();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.error("get alipay mobile pay request params sign failed", e);
            }
            throw new BusinessSilentException("\u7b7e\u540d\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u8d77\u652f\u4ed8");
        }
        timers.record("\u8ba1\u7b97\u7b7e\u540d");
        timers.print("use time alipay-sign");
        return params;
    }

    private AlipayConfiguration parseConfiguration(String configurationJson) {
        AlipayConfiguration alipayConfiguration = (AlipayConfiguration)JsonUtils.json2Obj((String)configurationJson, AlipayConfiguration.class);
        alipayConfiguration.setNotifyUrl(this.alipayGlobalConfiguration.getNotifyUrl());
        alipayConfiguration.setReturnUrl(this.alipayGlobalConfiguration.getReturnUrl());
        alipayConfiguration.setRefundNotifyUrl(this.alipayGlobalConfiguration.getRefundNotifyUrl());
        alipayConfiguration.setShowUrl(this.alipayGlobalConfiguration.getShowUrl());
        return alipayConfiguration;
    }

    private static /* synthetic */ PaymentOrderRefundStatusVO lambda$refundQuery$0(String mchOrderNo, AlipayConfiguration alipayConfiguration, AlipayClient alipayClient, String refundNo) {
        PaymentOrderRefundStatusVO paymentRefundRespVo = new PaymentOrderRefundStatusVO();
        paymentRefundRespVo.setMchRefundNo(refundNo);
        try {
            AlipayTradeFastpayRefundQueryRequest alipayTradeFastpayRefundQueryRequest = new AlipayTradeFastpayRefundQueryRequest();
            AlipayTradeRefundModel model = new AlipayTradeRefundModel();
            model.setOutTradeNo(mchOrderNo);
            model.setOutRequestNo(refundNo);
            alipayTradeFastpayRefundQueryRequest.setNotifyUrl(alipayConfiguration.getRefundNotifyUrl());
            alipayTradeFastpayRefundQueryRequest.setBizModel((AlipayObject)model);
            AlipayTradeFastpayRefundQueryResponse result = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)alipayTradeFastpayRefundQueryRequest);
            log.debug("Alipay return: {} for refund:{}", (Object)result.getBody(), (Object)mchOrderNo);
            paymentRefundRespVo.setRefundSuccess(Boolean.valueOf(result.isSuccess()));
            paymentRefundRespVo.setRefundTradNo(result.getTradeNo());
            paymentRefundRespVo.setRefundApplySuccess(Boolean.valueOf(true));
            paymentRefundRespVo.setProcessSuccess(true);
            return paymentRefundRespVo;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Got an exception from alipay refund.", (Throwable)e);
            }
            return paymentRefundRespVo;
        }
    }
}

