/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.alipay.config;

import com.ec.primus.commons.enums.ValuableEnum;
import com.ec.primus.commons.enums.converter.BaseEnumValueConverter;
import com.ec.primus.component.model.payment.enums.PaymentScene;

public enum AlipayTradeType implements ValuableEnum
{
    ALIPAY_MOBILE(PaymentScene.APP, 10, "APP\u652f\u4ed8(\u652f\u4ed8\u5b9d)", "mobile.securitypay.pay"),
    ALIPAY_PC(PaymentScene.PC, 11, "PC\u652f\u4ed8(\u652f\u4ed8\u5b9d)", "create_direct_pay_by_user"),
    ALIPAY_WAP(PaymentScene.WEB, 12, "H5\u652f\u4ed8(\u652f\u4ed8\u5b9d)", "alipay.wap.create.direct.pay.by.user"),
    ALIPAY_NATIVE(PaymentScene.SCAN_BY_CUSTOMER, 13, "\u626b\u7801\u652f\u4ed8(\u652f\u4ed8\u5b9d)", "alipay.trade.precreate");

    private PaymentScene paymentScene;
    private final int value;
    private final String tradeType;
    private final String desc;

    public static AlipayTradeType valueOf(Integer type) {
        for (AlipayTradeType paymentType : AlipayTradeType.values()) {
            if (paymentType.getValue() != type.intValue()) continue;
            return paymentType;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public PaymentScene getPaymentScene() {
        return this.paymentScene;
    }

    private AlipayTradeType(PaymentScene paymentScene, int value, String desc, String tradeType) {
        this.paymentScene = paymentScene;
        this.value = value;
        this.desc = desc;
        this.tradeType = tradeType;
    }

    public static class Converter
    extends BaseEnumValueConverter<AlipayTradeType> {
    }
}

