/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat;

import com.ec.primus.component.service.payment.service.component.wechat.config.SimpleWechatPaymentConfig;
import com.ec.primus.component.service.payment.service.component.wechat.lang.CertificateLoader;
import com.ec.primus.component.service.payment.service.component.wechat.lang.CheckName;
import com.ec.primus.component.service.payment.service.component.wechat.lang.Signer;
import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatTradeType;
import com.ec.primus.component.service.payment.service.component.wechat.req.CloseOrder;
import com.ec.primus.component.service.payment.service.component.wechat.req.OrderQuery;
import com.ec.primus.component.service.payment.service.component.wechat.req.OrderRefund;
import com.ec.primus.component.service.payment.service.component.wechat.req.RefundQuery;
import com.ec.primus.component.service.payment.service.component.wechat.req.Transfer;
import com.ec.primus.component.service.payment.service.component.wechat.req.TransferQuery;
import com.ec.primus.component.service.payment.service.component.wechat.req.UnifiedOrder;
import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import java.util.Properties;
import java.util.UUID;

public class WeChatPayFactory {
    private WeChatPayFactory() {
    }

    public static WeChatPayFactory newInstance() {
        return WeChatPayFactoryHolder.INSTANCE;
    }

    public Signer newSigner(Properties configProperties, String key) {
        return new Signer(configProperties, key);
    }

    public UnifiedOrder newUnifiedOrder(SimpleWechatPaymentConfig configProperties, String notifyUrl, String outTradeNo, String body, Long totalFee, String clientIp, WechatTradeType tradeType, String timeExpire, String openid) {
        UnifiedOrder unifiedOrder = new UnifiedOrder(outTradeNo, body, totalFee, clientIp, tradeType, timeExpire, openid);
        this.setConfigurations(configProperties, unifiedOrder);
        unifiedOrder.setProperty("attach", configProperties.getKey());
        unifiedOrder.setProperty("notify_url", notifyUrl);
        return unifiedOrder;
    }

    public OrderQuery newOrderQuery(SimpleWechatPaymentConfig configProperties, String transactionId, String outTradeNo) {
        OrderQuery orderQuery = new OrderQuery(transactionId, outTradeNo);
        this.setConfigurations(configProperties, orderQuery);
        return orderQuery;
    }

    public CloseOrder newCloseOrder(SimpleWechatPaymentConfig configProperties, String outTradeNo) {
        CloseOrder closeOrder = new CloseOrder(outTradeNo);
        this.setConfigurations(configProperties, closeOrder);
        return closeOrder;
    }

    public OrderRefund newOrderRefund(SimpleWechatPaymentConfig wechatPaymentConfig, String transactionId, String outTradeNo, String outRefundNo, Long totalFee, Long refundFee) {
        OrderRefund refundOrder = new OrderRefund(transactionId, outTradeNo, outRefundNo, totalFee, refundFee);
        refundOrder.setSslContext(new CertificateLoader(wechatPaymentConfig.getIdentificationFile(), wechatPaymentConfig.getIdentificationPwd()).getSSLContext());
        this.setConfigurations(wechatPaymentConfig, refundOrder);
        refundOrder.setProperty("op_user_id", wechatPaymentConfig.getMchId());
        return refundOrder;
    }

    public RefundQuery newRefundQuery(SimpleWechatPaymentConfig wechatPaymentConfig, String refundId, String outRefundNo) {
        RefundQuery refundQuery = new RefundQuery(refundId, outRefundNo);
        this.setConfigurations(wechatPaymentConfig, refundQuery);
        return refundQuery;
    }

    public Transfer newTransfer(SimpleWechatPaymentConfig wechatPaymentConfig, String partnerTradeNo, String openid, Integer amount, String desc, CheckName checkName, String receiverName) {
        Transfer transfer = new Transfer(partnerTradeNo, openid, amount, desc, checkName, receiverName);
        transfer.setSslContext(new CertificateLoader(wechatPaymentConfig.getIdentificationFile(), wechatPaymentConfig.getMchId()).getSSLContext());
        this.setConfigurations(wechatPaymentConfig, transfer);
        transfer.setProperty("mch_appid", wechatPaymentConfig.getAppId());
        transfer.setProperty("mchid", wechatPaymentConfig.getMchId());
        transfer.setProperty("spbill_create_ip", wechatPaymentConfig.getSpbillCreateIp());
        return transfer;
    }

    public TransferQuery newTransferQuery(SimpleWechatPaymentConfig configProperties, String partnerTradeNo) {
        TransferQuery refundQuery = new TransferQuery(partnerTradeNo);
        this.setConfigurations(configProperties, refundQuery);
        refundQuery.setSslContext(new CertificateLoader(configProperties.getIdentificationFile(), configProperties.getMchId()).getSSLContext());
        return refundQuery;
    }

    private void setConfigurations(SimpleWechatPaymentConfig wechatPaymentConfig, WechatPayRequestBase wechatPayRequestBase) {
        wechatPayRequestBase.setProperties(wechatPaymentConfig.toProperties());
        wechatPayRequestBase.setProperty("appid", wechatPaymentConfig.getAppId());
        wechatPayRequestBase.setProperty("mch_id", wechatPaymentConfig.getMchId());
        wechatPayRequestBase.setProperty("key", wechatPaymentConfig.getKey());
        wechatPayRequestBase.setProperty("nonce_str", UUID.randomUUID().toString().replaceAll("-", ""));
    }

    private static class WeChatPayFactoryHolder {
        private static final WeChatPayFactory INSTANCE = new WeChatPayFactory();

        private WeChatPayFactoryHolder() {
        }
    }
}

