/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.utils.JsonUtils;
import com.ec.primus.component.model.payment.service.IPaymentServiceComponent;
import com.ec.primus.component.model.payment.vo.paymentorder.CommonPaidRespVo;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyValidateResultVO;
import com.ec.primus.component.service.payment.service.component.wechat.WeChatPayFactory;
import com.ec.primus.component.service.payment.service.component.wechat.config.SimpleWechatPaymentConfig;
import com.ec.primus.component.service.payment.service.component.wechat.config.WechatPayGlobalConfiguration;
import com.ec.primus.component.service.payment.service.component.wechat.exceptions.PaymentException;
import com.ec.primus.component.service.payment.service.component.wechat.lang.RefundStatus;
import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatTradeType;
import com.ec.primus.component.service.payment.service.component.wechat.req.OrderRefund;
import com.ec.primus.component.service.payment.service.component.wechat.req.RefundQuery;
import com.ec.primus.component.service.payment.service.component.wechat.req.UnifiedOrder;
import com.ec.primus.component.service.payment.service.component.wechat.res.OrderQueryResponse;
import com.ec.primus.component.service.payment.service.component.wechat.res.RefundQueryResponse;
import com.ec.primus.component.service.payment.service.component.wechat.res.RefundResponse;
import com.ec.primus.component.service.payment.service.component.wechat.res.SignAble;
import com.ec.primus.component.service.payment.service.component.wechat.res.WechatPayNotifyRespVo;
import com.ec.primus.component.service.payment.service.component.wechat.res.WechatPayRespVo;
import com.ec.primus.component.service.payment.service.component.wechat.res.WechatRefundNotifyRespVo;
import com.ec.primus.component.service.payment.service.component.wechat.vo.WechatJSUnifiedOrderResVo;
import com.ec.primus.component.service.payment.service.component.wechat.vo.WechatPayResp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatPaymentServiceComponent
implements IPaymentServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(WechatPaymentServiceComponent.class);
    private final WechatPayGlobalConfiguration wechatPayGlobalConfiguration;

    @Autowired
    public WechatPaymentServiceComponent(WechatPayGlobalConfiguration wechatPayGlobalConfiguration) {
        this.wechatPayGlobalConfiguration = wechatPayGlobalConfiguration;
    }

    public Object createPayment(String tradeTypeConfigurationJson, PaymentOrderCreateReqVO reqVO) {
        String errorMsg;
        if (log.isDebugEnabled()) {
            log.debug("getMchOrderNo {}", (Object)reqVO);
        }
        try {
            WechatTradeType requestTradeType = WechatTradeType.valueOf(reqVO.getTradeType());
            SimpleWechatPaymentConfig configProperties = this.getWechatPaymentConfig(tradeTypeConfigurationJson);
            WeChatPayFactory weChatPayFactory = WeChatPayFactory.newInstance();
            String timeExpire = DateFormatUtils.format((Date)reqVO.getExpireTime(), (String)"yyyyMMddHHmmss");
            UnifiedOrder unifiedOrder = weChatPayFactory.newUnifiedOrder(configProperties, configProperties.getNotifyUrl(), reqVO.getMchOrderNo(), reqVO.getSubject(), reqVO.getAmount(), reqVO.getClientIp(), requestTradeType, timeExpire, reqVO.getPayAccount());
            unifiedOrder.setProperty("attach", reqVO.getMchId());
            WechatPayRespVo unifiedOrderResponse = (WechatPayRespVo)unifiedOrder.execute();
            if (log.isDebugEnabled()) {
                log.debug("Get response from wechat: {}", (Object)unifiedOrderResponse.getProperties());
            }
            if (unifiedOrderResponse.isProcessSuccess().booleanValue()) {
                SignAble resp;
                String currentTimestamp = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
                switch (requestTradeType) {
                    case NATIVE: {
                        return unifiedOrderResponse.getProperty("code_url");
                    }
                    case JSAPI: {
                        WechatJSUnifiedOrderResVo wechatJSUnifiedOrderResVo = new WechatJSUnifiedOrderResVo();
                        wechatJSUnifiedOrderResVo.setAppId(unifiedOrderResponse.getAppId());
                        wechatJSUnifiedOrderResVo.setPrepayId(unifiedOrderResponse.getPrepayId());
                        wechatJSUnifiedOrderResVo.setNonceStr(unifiedOrderResponse.getNonceStr());
                        wechatJSUnifiedOrderResVo.setTimeStamp(currentTimestamp);
                        resp = wechatJSUnifiedOrderResVo;
                        break;
                    }
                    default: {
                        WechatPayResp wechatPayResp = new WechatPayResp();
                        wechatPayResp.setMchId(configProperties.getMchId());
                        wechatPayResp.setMchOrderNo(reqVO.getMchOrderNo());
                        wechatPayResp.setAppid(configProperties.getAppId());
                        wechatPayResp.setPartnerid(unifiedOrderResponse.getMchId());
                        wechatPayResp.setPrepayid(unifiedOrderResponse.getPrepayId());
                        wechatPayResp.setNoncestr(unifiedOrderResponse.getNonceStr());
                        wechatPayResp.setTimestamp(currentTimestamp);
                        wechatPayResp.setOrderId(reqVO.getMchOrderNo());
                        resp = wechatPayResp;
                    }
                }
                String sign = weChatPayFactory.newSigner(configProperties.toProperties(), configProperties.getKey()).sign(resp);
                resp.setSign(sign);
                return resp;
            }
            errorMsg = StringUtils.isNotBlank((CharSequence)unifiedOrderResponse.getErrorDescption()) ? unifiedOrderResponse.getErrorDescption() : unifiedOrderResponse.getReturnMessage();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("\u751f\u6210\u9884\u4ed8\u5355\u5931\u8d25.", (Throwable)e);
            }
            errorMsg = e.getMessage();
        }
        throw new PaymentException(errorMsg);
    }

    public CommonPaidRespVo isPad(String configJson, String tradeNo, String mchOrderNo) {
        try {
            SimpleWechatPaymentConfig wechatPaymentConfig = this.getWechatPaymentConfig(configJson);
            OrderQueryResponse orderQueryResponse = (OrderQueryResponse)WeChatPayFactory.newInstance().newOrderQuery(wechatPaymentConfig, tradeNo, mchOrderNo).execute();
            return new CommonPaidRespVo(orderQueryResponse.getTradeNo(), orderQueryResponse.isPaid(), orderQueryResponse.getTimeEnd(), orderQueryResponse.getOpenId());
        }
        catch (Exception e) {
            throw new BusinessSilentException("Got an exception when query wechat payment status", (Throwable)e);
        }
    }

    public PaymentOrderRefundRespVO refund(String configurationJson, PaymentOrderRefundReqVO reqVO) {
        String errorMsg;
        try {
            SimpleWechatPaymentConfig wechatPaymentConfig = this.getWechatPaymentConfig(configurationJson);
            OrderRefund orderRefund = WeChatPayFactory.newInstance().newOrderRefund(wechatPaymentConfig, null, reqVO.getMchOrderNo(), reqVO.getRefundNo(), reqVO.getTotalAmount(), reqVO.getRefundAmount());
            RefundResponse refundResponse = (RefundResponse)orderRefund.execute();
            if (refundResponse.isProcessSuccess().booleanValue()) {
                PaymentOrderRefundRespVO paymentRefundRespVo = new PaymentOrderRefundRespVO();
                paymentRefundRespVo.setProcessSuccess(true);
                paymentRefundRespVo.setRefundApplySuccess(Boolean.valueOf(true));
                paymentRefundRespVo.setOutRefundNo(reqVO.getRefundNo());
                paymentRefundRespVo.setRefundTradeNo(refundResponse.getRefundId());
                return paymentRefundRespVo;
            }
            errorMsg = StringUtils.isNotBlank((CharSequence)refundResponse.getErrorDescption()) ? refundResponse.getErrorDescption() : refundResponse.getReturnMessage();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u5355:{}.", (Object)JsonUtils.obj2Json((Object)reqVO), (Object)e);
            }
            errorMsg = e.getMessage();
        }
        throw new PaymentException(errorMsg);
    }

    public PaymentOrderRefundStatusCheckRespVO refundQuery(String configurationJson, String mchOrderNo, List<String> refundRequestNos) {
        SimpleWechatPaymentConfig wechatPaymentConfig = this.getWechatPaymentConfig(configurationJson);
        PaymentOrderRefundStatusCheckRespVO paymentOrderRefundStatusCheckRespVO = new PaymentOrderRefundStatusCheckRespVO();
        List paymentOrderRefundStatusCheckRespVOS = refundRequestNos.stream().map(refundRequestNo -> {
            PaymentOrderRefundStatusVO paymentRefundRespVo;
            try {
                RefundQuery refundQuery = WeChatPayFactory.newInstance().newRefundQuery(wechatPaymentConfig, null, (String)refundRequestNo);
                RefundQueryResponse queryResponse = (RefundQueryResponse)refundQuery.execute();
                paymentRefundRespVo = this.parseRefundQueryResponse(queryResponse);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("\u67e5\u8be2\u9000\u6b3e\u5931\u8d25.", (Throwable)e);
                }
                paymentRefundRespVo = new PaymentOrderRefundStatusVO();
            }
            paymentRefundRespVo.setMchRefundNo(refundRequestNo);
            return paymentRefundRespVo;
        }).collect(Collectors.toList());
        paymentOrderRefundStatusCheckRespVO.setPaymentOrderRefundStatusVOs(paymentOrderRefundStatusCheckRespVOS);
        return paymentOrderRefundStatusCheckRespVO;
    }

    public PaymentPayNotifyParseResultVO parsePayNotify(String notifyData) {
        WechatPayNotifyRespVo notifyRes = new WechatPayNotifyRespVo(notifyData, "xml");
        PaymentPayNotifyParseResultVO paymentPayNotifyParseResultVO = new PaymentPayNotifyParseResultVO();
        paymentPayNotifyParseResultVO.setMchId(notifyRes.getAttach());
        paymentPayNotifyParseResultVO.setMchOrderNo(notifyRes.getOutTradeNo());
        return paymentPayNotifyParseResultVO;
    }

    public PaymentPayNotifyValidateResultVO validatePayNotify(String configurationJson, String notifyData) {
        return null;
    }

    public PaymentRefundNotifyParseResultVO parseRefundNotify(String notifyData) {
        WechatRefundNotifyRespVo notifyRes = new WechatRefundNotifyRespVo(notifyData, "xml");
        PaymentRefundNotifyParseResultVO resultVO = new PaymentRefundNotifyParseResultVO();
        resultVO.setMchOrderNo(notifyRes.getOutTradeNo());
        return resultVO;
    }

    public PaymentRefundNotifyValidateResultVO validateRefundNotify(String configurationJson, String notifyData) {
        return null;
    }

    private SimpleWechatPaymentConfig getWechatPaymentConfig(String configurationJson) {
        SimpleWechatPaymentConfig simpleWechatPaymentConfig = (SimpleWechatPaymentConfig)JsonUtils.json2Obj((String)configurationJson, SimpleWechatPaymentConfig.class);
        simpleWechatPaymentConfig.setReturnUrl(this.wechatPayGlobalConfiguration.getReturnUrl());
        simpleWechatPaymentConfig.setNotifyUrl(this.wechatPayGlobalConfiguration.getNotifyUrl());
        simpleWechatPaymentConfig.setShowUrl(this.wechatPayGlobalConfiguration.getShowUrl());
        simpleWechatPaymentConfig.setRefundNotifyUrl(this.wechatPayGlobalConfiguration.getRefundNotifyUrl());
        return simpleWechatPaymentConfig;
    }

    WechatPayNotifyRespVo parsePayNotifyRespVo(String xmlBody) {
        WechatPayNotifyRespVo notifyRes = new WechatPayNotifyRespVo(xmlBody, "xml");
        return notifyRes;
    }

    private PaymentOrderRefundStatusVO parseRefundQueryResponse(RefundQueryResponse queryResponse) {
        RefundStatus refundStatus = queryResponse.getRefundStatus();
        PaymentOrderRefundStatusVO paymentRefundRespVo = new PaymentOrderRefundStatusVO();
        paymentRefundRespVo.setMchRefundNo(queryResponse.getOutTradeNo());
        paymentRefundRespVo.setRefundTradNo(queryResponse.getTradeNo());
        paymentRefundRespVo.setRefundApplySuccess(Boolean.valueOf(true));
        paymentRefundRespVo.setProcessSuccess(true);
        paymentRefundRespVo.setRefunding(Boolean.valueOf(Objects.equals((Object)refundStatus, (Object)RefundStatus.PROCESSING)));
        paymentRefundRespVo.setRefundSuccess(Boolean.valueOf(Objects.equals((Object)refundStatus, (Object)RefundStatus.SUCCESS)));
        paymentRefundRespVo.setRetryAble(Boolean.valueOf(Objects.equals((Object)refundStatus, (Object)RefundStatus.NOTSURE)));
        paymentRefundRespVo.setNeedManualCheck(Boolean.valueOf(Objects.equals((Object)refundStatus, (Object)RefundStatus.CHANGE)));
        return paymentRefundRespVo;
    }

    public WechatRefundNotifyRespVo parseRefundNotifyRespVo(String xmlBody) {
        WechatRefundNotifyRespVo notifyResps = new WechatRefundNotifyRespVo(xmlBody, "xml");
        return notifyResps;
    }
}

