/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat;

import com.ec.primus.commons.utils.JsonUtils;
import com.ec.primus.component.model.payment.service.IPaymentServiceComponent;
import com.ec.primus.component.model.payment.vo.IPaymentChannel;
import com.ec.primus.component.model.payment.vo.PaymentChannelRegisterVO;
import com.ec.primus.component.model.payment.vo.PaymentChannelVO;
import com.ec.primus.component.model.payment.vo.TradeTypeVO;
import com.ec.primus.component.service.payment.service.PaymentChannelRegister;
import com.ec.primus.component.service.payment.service.component.wechat.WechatPaymentServiceComponent;
import com.ec.primus.component.service.payment.service.component.wechat.config.SimpleWechatPaymentConfig;
import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatTradeType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class WechatPaymentServiceComponentRegister {
    @Autowired
    private WechatPaymentServiceComponent wechatPaymentServiceComponent;
    @Autowired
    private PaymentChannelRegister paymentChannelRegister;

    @PostConstruct
    public void register() {
        PaymentChannelRegisterVO reqVO = new PaymentChannelRegisterVO();
        PaymentChannelVO paymentChannel = new PaymentChannelVO("WechatPay", "\u5fae\u4fe1\u652f\u4ed8", "\u817e\u8baf\u65d7\u4e0b\u5fae\u4fe1\u652f\u4ed8");
        reqVO.setPaymentChannel((IPaymentChannel)paymentChannel);
        ArrayList tradeTypes = Lists.newArrayList();
        for (WechatTradeType wechatTradeType : WechatTradeType.values()) {
            TradeTypeVO tradeType = new TradeTypeVO(paymentChannel, wechatTradeType.name(), wechatTradeType.getPaymentScene(), wechatTradeType.name(), wechatTradeType.getDesc(), this.buildDemoConfig());
            tradeTypes.add(tradeType);
        }
        reqVO.setTradeTypes((Collection)tradeTypes);
        reqVO.setPaymentServiceComponent((IPaymentServiceComponent)this.wechatPaymentServiceComponent);
        this.paymentChannelRegister.register(reqVO);
    }

    protected String buildDemoConfig() {
        SimpleWechatPaymentConfig simpleWechatPaymentConfig = new SimpleWechatPaymentConfig();
        simpleWechatPaymentConfig.setAppId("wxa4eab8e7xxxxxxxx");
        simpleWechatPaymentConfig.setMchId("1491888888");
        simpleWechatPaymentConfig.setKey("MIIEuwIBADANBgkqhkiG9w0Bxxxxxxxx");
        simpleWechatPaymentConfig.setIdentificationFile("/opt/data/wxa4eab8e7xxxxxxxx.p12");
        simpleWechatPaymentConfig.setIdentificationPwd("12345678");
        return JsonUtils.obj2Json((Object)simpleWechatPaymentConfig);
    }
}

