/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.config;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class WechatPaymentConfigOfEnvironment {
    private static final Logger log = LoggerFactory.getLogger(WechatPaymentConfigOfEnvironment.class);
    private static final ThreadLocal<String> APP_ID_STORAGE = new ThreadLocal();
    private Environment environment;

    public WechatPaymentConfigOfEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String getReturnUrl() {
        return this.environment.getProperty("primus.payment.returnUrl");
    }

    public String getShowUrl() {
        return this.environment.getProperty("primus.payment.showUrl");
    }

    public String getNotifyUrl() {
        return this.environment.getProperty("primus.payment.wechat.notifyUrl");
    }

    public String getRefundNotifyUrl() {
        return this.environment.getProperty("primus.payment.wechat.refundNotifyUrl");
    }

    public void setAppId(String appId) {
        APP_ID_STORAGE.set(appId);
    }

    public Properties toProperties() {
        String loadIdentification;
        Properties properties = new Properties();
        properties.put("appid", this.getAppId());
        properties.put("mch_id", this.getMchId());
        properties.put("key", this.getKey());
        String spbillCreateIp = this.getSpbillCreateIp();
        if (spbillCreateIp != null) {
            properties.put("spbill_create_ip", spbillCreateIp);
        }
        if ((loadIdentification = this.getLoadIdentification()) != null) {
            properties.put("LOAD_IDENTIFICATION", loadIdentification);
        }
        return properties;
    }

    public String getAppId() {
        String appId = APP_ID_STORAGE.get();
        if (StringUtils.isBlank((CharSequence)appId)) {
            String key = "primus.payment.wechat.defaultAppId";
            String defaultAppIdFromConfig = this.environment.getProperty(key);
            log.debug("Load defaultAppId:[{}] from environment config by key:[{}]", (Object)defaultAppIdFromConfig, (Object)key);
            return defaultAppIdFromConfig;
        }
        return appId;
    }

    public String getMchId() {
        String key = "primus.payment.wechat." + this.getAppId() + ".mchId";
        String mchIdFromConfig = this.environment.getProperty(key);
        log.debug("Load mchId:[{}] from environment config by key:[{}]", (Object)mchIdFromConfig, (Object)key);
        return mchIdFromConfig;
    }

    public String getLoadIdentification() {
        return this.environment.getProperty("primus.payment.wechat." + this.getAppId() + ".loadIdentification");
    }

    public String getSpbillCreateIp() {
        return this.environment.getProperty("primus.payment.wechat.server.ip");
    }

    public String getKey() {
        String key = "primus.payment.wechat." + this.getAppId() + ".key";
        String keyFromConfig = this.environment.getProperty(key);
        log.debug("Load key:[{}] from environment config by key:[{}]", (Object)keyFromConfig, (Object)key);
        return keyFromConfig;
    }
}

