/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.MissingResourceException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class CertificateLoader {
    private static final String ALGORITHM = "TLSv1";
    private KeyStore identification;
    private String passPhrase;

    public CertificateLoader(String identificationPath, String pws) {
        this.passPhrase = pws;
        this.loadIdentification(identificationPath, pws);
    }

    public SSLContext getSSLContext() {
        try {
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmFactory.init(this.identification, this.passPhrase.toCharArray());
            KeyManager[] km = kmFactory.getKeyManagers();
            SSLContext sslCtx = SSLContext.getInstance(ALGORITHM);
            sslCtx.init(km, null, null);
            return sslCtx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadIdentification(String resourcePath, String pwd) {
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(resourcePath);
            if (stream == null) {
                File targetFile = new File(resourcePath);
                if (targetFile.exists()) {
                    stream = new FileInputStream(targetFile);
                } else {
                    throw new MissingResourceException("Load identification failed.", CertificateLoader.class.getName(), resourcePath);
                }
            }
            this.identification = KeyStore.getInstance("PKCS12");
            this.identification.load(stream, pwd.toCharArray());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

