/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.lang;

import com.ec.primus.commons.enums.ValuableEnum;
import com.ec.primus.commons.enums.converter.BaseEnumValueConverter;
import com.ec.primus.component.model.payment.enums.PaymentScene;

public enum WechatTradeType implements ValuableEnum
{
    APP(PaymentScene.APP, 20, "APP\u652f\u4ed8(\u5fae\u4fe1)", "APP"),
    NATIVE(PaymentScene.SCAN_BY_CUSTOMER, 21, "\u626b\u7801\u652f\u4ed8(\u5fae\u4fe1)", "NATIVE"),
    MWEB(PaymentScene.WEB, 22, "H5\u652f\u4ed8(\u5fae\u4fe1)", "MWEB"),
    JSAPI(PaymentScene.OFFICIAL, 23, "\u516c\u4f17\u53f7\u652f\u4ed8(\u5fae\u4fe1)", "JSAPI");

    private PaymentScene paymentScene;
    private final int value;
    private final String tradeType;
    private final String desc;

    public static WechatTradeType valueOf(Integer type) {
        for (WechatTradeType paymentType : WechatTradeType.values()) {
            if (paymentType.getValue() != type.intValue()) continue;
            return paymentType;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public PaymentScene getPaymentScene() {
        return this.paymentScene;
    }

    private WechatTradeType(PaymentScene paymentScene, int value, String desc, String tradeType) {
        this.paymentScene = paymentScene;
        this.value = value;
        this.desc = desc;
        this.tradeType = tradeType;
    }

    public static class Converter
    extends BaseEnumValueConverter<WechatTradeType> {
    }
}

