/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.req;

import com.ec.primus.commons.utils.ValueUtils;
import com.ec.primus.component.service.payment.service.component.wechat.lang.SimpleHttpClient;
import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import com.ec.primus.component.service.payment.service.component.wechat.res.RefundResponse;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class OrderRefund
extends WechatPayRequestBase<RefundResponse> {
    private static final String API_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("appid", "mch_id", "transaction_id", "out_trade_no", "out_refund_no", "total_fee", "refund_fee", "op_user_id", "nonce_str", "sign"));
    private SSLContext sslContext;

    public OrderRefund(String transactionId, String outTradeNo, String outRefundNo, Long totalFee, Long refundFee) {
        if (StringUtils.isBlank((CharSequence)transactionId) && StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("Argument transactionId and outTradeNo can not be both empty.");
        }
        if (StringUtils.isBlank((CharSequence)outRefundNo)) {
            throw new IllegalArgumentException("Argument outRefundNo can not be blank.");
        }
        if (ValueUtils.getValue((Long)totalFee) < 1L) {
            throw new IllegalArgumentException("Argument totalFee can not less than 1.");
        }
        if (ValueUtils.getValue((Long)refundFee) < 1L) {
            throw new IllegalArgumentException("Argument refundFee can not less than 1.");
        }
        if (refundFee > totalFee) {
            throw new IllegalArgumentException("Argument refundFee can not greater than totalFee.");
        }
        this.setProperty("transaction_id", transactionId);
        this.setProperty("out_trade_no", outTradeNo);
        this.setProperty("out_refund_no", outRefundNo);
        this.setProperty("total_fee", totalFee.toString());
        this.setProperty("refund_fee", refundFee.toString());
    }

    @Override
    protected SimpleHttpClient getSimpleHttpClient() {
        if (this.sslContext == null) {
            throw new IllegalArgumentException("sslContext can not be null");
        }
        return new SimpleHttpClient(this.sslContext);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected RefundResponse parseResponse(String responseBody) {
        return new RefundResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

