/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.req;

import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import com.ec.primus.component.service.payment.service.component.wechat.res.RefundQueryResponse;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class RefundQuery
extends WechatPayRequestBase<RefundQueryResponse> {
    public static final String API_URL = "https://api.mch.weixin.qq.com/pay/refundquery";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("refund_id", "out_refund_no", "appid", "mch_id", "nonce_str", "sign"));

    public RefundQuery(String refundId, String outRefundNo) {
        if (StringUtils.isBlank((CharSequence)refundId) && StringUtils.isBlank((CharSequence)outRefundNo)) {
            throw new IllegalArgumentException("Argument refundId and outRefundNo can not be both empty.");
        }
        this.setProperty("refund_id", refundId);
        this.setProperty("out_refund_no", outRefundNo);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected RefundQueryResponse parseResponse(String responseBody) {
        return new RefundQueryResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }
}

