/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.req;

import com.ec.primus.commons.utils.ValueUtils;
import com.ec.primus.component.service.payment.service.component.wechat.lang.CheckName;
import com.ec.primus.component.service.payment.service.component.wechat.lang.SimpleHttpClient;
import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import com.ec.primus.component.service.payment.service.component.wechat.res.TransferResponse;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class Transfer
extends WechatPayRequestBase<TransferResponse> {
    private static final String API_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("mch_appid", "mchid", "nonce_str", "sign", "partner_trade_no", "openid", "check_name", "re_user_name", "amount", "desc", "spbill_create_ip"));
    private SSLContext sslContext;

    public Transfer(String partnerTradeNo, String openid, Integer amount, String desc, CheckName checkName, String receiverName) {
        if (StringUtils.isBlank((CharSequence)partnerTradeNo)) {
            throw new IllegalArgumentException("Argument partnerTradeNo can not be blank.");
        }
        if (StringUtils.isBlank((CharSequence)openid)) {
            throw new IllegalArgumentException("Argument openid can not be blank.");
        }
        if (ValueUtils.getValue((Integer)amount) < 1) {
            throw new IllegalArgumentException("Argument totalFee can not less than 1.");
        }
        if (StringUtils.isBlank((CharSequence)desc)) {
            throw new IllegalArgumentException("Argument desc can not be blank.");
        }
        if (checkName == null) {
            throw new IllegalArgumentException("Argument checkName can not be null.");
        }
        if (checkName != CheckName.NO_CHECK && StringUtils.isBlank((CharSequence)receiverName)) {
            throw new IllegalArgumentException("Argument receiverName can not be blank when checkName != NO_CHECK .");
        }
        this.setProperty("partner_trade_no", partnerTradeNo);
        this.setProperty("openid", openid);
        this.setProperty("amount", amount.toString());
        this.setProperty("desc", desc);
        this.setProperty("check_name", checkName.name());
        if (StringUtils.isNotBlank((CharSequence)receiverName)) {
            this.setProperty("re_user_name", receiverName);
        }
    }

    @Override
    protected SimpleHttpClient getSimpleHttpClient() {
        if (this.sslContext == null) {
            throw new IllegalArgumentException("sslContext can not be null");
        }
        return new SimpleHttpClient(this.sslContext);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected TransferResponse parseResponse(String responseBody) {
        return new TransferResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

