/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.req;

import com.ec.primus.component.service.payment.service.component.wechat.lang.SimpleHttpClient;
import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import com.ec.primus.component.service.payment.service.component.wechat.res.TransferQueryResponse;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class TransferQuery
extends WechatPayRequestBase<TransferQueryResponse> {
    private static final String API_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("appid", "mch_id", "nonce_str", "sign", "partner_trade_no"));
    private SSLContext sslContext;

    public TransferQuery(String partnerTradeNo) {
        if (StringUtils.isBlank((CharSequence)partnerTradeNo)) {
            throw new IllegalArgumentException("Argument partnerTradeNo can not be blank.");
        }
        this.setProperty("partner_trade_no", partnerTradeNo);
    }

    @Override
    protected SimpleHttpClient getSimpleHttpClient() {
        if (this.sslContext == null) {
            throw new IllegalArgumentException("sslContext can not be null");
        }
        return new SimpleHttpClient(this.sslContext);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected TransferQueryResponse parseResponse(String responseBody) {
        return new TransferQueryResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

