/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.req;

import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatTradeType;
import com.ec.primus.component.service.payment.service.component.wechat.req.WechatPayRequestBase;
import com.ec.primus.component.service.payment.service.component.wechat.res.WechatPayRespVo;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class UnifiedOrder
extends WechatPayRequestBase<WechatPayRespVo> {
    public static final String API_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("body", "openid", "out_trade_no", "product_id", "spbill_create_ip", "total_fee", "trade_type", "appid", "attach", "device_info", "goods_tag", "mch_id", "nonce_str", "notify_url", "sign", "time_start", "time_expire", "sub_appid", "sub_mch_id", "sub_openid"));

    public UnifiedOrder(String outTradeNo, String body, Long totalFee, String clientIp, WechatTradeType tradeType, String timeExpire, String openid) {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("outTradeNo can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new IllegalArgumentException("body can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)clientIp)) {
            throw new IllegalArgumentException("clientIp can not be empty.");
        }
        if (tradeType == null) {
            throw new IllegalArgumentException("tradeType can not be null.");
        }
        if (timeExpire != null && !timeExpire.matches("^\\d{14}$")) {
            throw new IllegalArgumentException("timeExpire format pattern is 'yyyyMMddHHmmss'");
        }
        this.setProperty("out_trade_no", outTradeNo);
        this.setProperty("body", StringUtils.left((String)body, (int)30));
        this.setProperty("total_fee", totalFee.toString());
        this.setProperty("spbill_create_ip", clientIp);
        this.setProperty("trade_type", tradeType.name());
        this.setProperty("time_expire", timeExpire);
        if (StringUtils.isNotBlank((CharSequence)openid)) {
            this.setProperty("openid", openid);
        }
    }

    public UnifiedOrder(String outTradeNo, String body, Integer totalFee, String clientIp, String timeExpire, String openid, String subOpenid) {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("outTradeNo can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new IllegalArgumentException("body can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)clientIp)) {
            throw new IllegalArgumentException("clientIp can not be empty.");
        }
        if (timeExpire != null && !timeExpire.matches("^\\d{14}$")) {
            throw new IllegalArgumentException("timeExpire format pattern is 'yyyyMMddHHmmss'");
        }
        if (StringUtils.isEmpty((CharSequence)openid) && StringUtils.isEmpty((CharSequence)subOpenid)) {
            throw new IllegalArgumentException("openid or subOpenid can not be all empty.");
        }
        this.setProperty("out_trade_no", outTradeNo);
        this.setProperty("body", StringUtils.left((String)body, (int)30));
        this.setProperty("total_fee", totalFee.toString());
        this.setProperty("spbill_create_ip", clientIp);
        this.setProperty("trade_type", WechatTradeType.JSAPI.name());
        if (StringUtils.isNotEmpty((CharSequence)timeExpire)) {
            this.setProperty("time_expire", timeExpire);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{openid})) {
            this.setProperty("openid", openid);
        }
        if (StringUtils.isNotBlank((CharSequence)subOpenid)) {
            this.setProperty("sub_openid", subOpenid);
        }
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    @Override
    protected WechatPayRespVo parseResponse(String responseXml) {
        return new WechatPayRespVo(responseXml);
    }
}

