/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service.component.wechat.res;

import com.ec.primus.commons.utils.DateUtils;
import com.ec.primus.component.service.payment.service.component.wechat.WeChatPayFactory;
import com.ec.primus.component.service.payment.service.component.wechat.exceptions.SignIncorrectException;
import com.ec.primus.component.service.payment.service.component.wechat.exceptions.WechatResponseParseException;
import com.ec.primus.component.service.payment.service.component.wechat.lang.PropertyCollector;
import com.ec.primus.component.service.payment.service.component.wechat.lang.ReturnCode;
import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatPayResultCode;
import com.ec.primus.component.service.payment.service.component.wechat.lang.WechatTradeType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseWechatPayRespVo
implements Serializable {
    private static final long serialVersionUID = 3470857600550538913L;
    protected Properties properties;

    protected String[] getIgnoreParams() {
        return null;
    }

    public BaseWechatPayRespVo(String responseXml) throws IllegalArgumentException, WechatResponseParseException {
        if (StringUtils.isBlank((CharSequence)responseXml)) {
            throw new IllegalArgumentException("Argument responseXml can not be blank.");
        }
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream source = new ByteArrayInputStream(responseXml.getBytes("utf-8"));
            PropertyCollector pc = new PropertyCollector();
            saxParser.parse((InputStream)source, (DefaultHandler)pc);
            this.properties = pc.returnProperties();
        }
        catch (Exception e) {
            throw new WechatResponseParseException(e);
        }
    }

    public void signValidate() throws SignIncorrectException {
        String sign;
        if (ArrayUtils.isNotEmpty((Object[])this.getIgnoreParams())) {
            for (String ignoreParam : this.getIgnoreParams()) {
                this.properties.remove(ignoreParam);
            }
        }
        if (!Objects.equals(sign = WeChatPayFactory.newInstance().newSigner(this.properties, this.getAppId()).sign(this.properties), this.getSign())) {
            throw new SignIncorrectException(String.format("expected:[%s], but get:[%s]", sign, this.getSign()));
        }
    }

    public Boolean isProcessSuccess() {
        return this.getReturnCode() == ReturnCode.SUCCESS && Objects.equals((Object)this.getResultCode(), (Object)WechatPayResultCode.SUCCESS);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public WechatTradeType getTradeType() {
        return this.getEnumInstance(WechatTradeType.class, this.properties.getProperty("trade_type"));
    }

    public ReturnCode getReturnCode() {
        return this.getEnumInstance(ReturnCode.class, this.properties.getProperty("return_code"));
    }

    public String getReturnMessage() {
        return this.properties.getProperty("return_msg");
    }

    public String getAppId() {
        return this.properties.getProperty("appid");
    }

    public String getMchId() {
        return this.properties.getProperty("mch_id");
    }

    public String getNonceStr() {
        return this.properties.getProperty("nonce_str");
    }

    public String getSign() {
        return this.properties.getProperty("sign");
    }

    public String getTradeNo() {
        return this.getProperty("transaction_id");
    }

    public String getOutTradeNo() {
        return this.getProperty("out_trade_no");
    }

    public String getOpenId() {
        return this.getProperty("openid");
    }

    public Date getTimeEnd() {
        String timeEnd = this.getProperty("time_end");
        return StringUtils.isBlank((CharSequence)timeEnd) ? null : DateUtils.getTimestamp((String)timeEnd, (String)"yyyyMMddHHmmss");
    }

    public WechatPayResultCode getResultCode() {
        return this.getEnumInstance(WechatPayResultCode.class, this.properties.getProperty("result_code"));
    }

    public String getErrorCode() {
        return this.properties.getProperty("err_code");
    }

    public String getErrorDescption() {
        return this.properties.getProperty("err_code_des");
    }

    protected <T extends Enum> T getEnumInstance(Class<T> ct, String name) {
        return StringUtils.isBlank((CharSequence)name) ? null : (T)Enum.valueOf(ct, name);
    }
}

