/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.upgrade.service;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.base.exception.BizBusinessException;
import com.ec.primus.component.model.upgrade.enums.UpgradeExceptionEnum;
import com.ec.primus.component.model.upgrade.vo.UpgradeCheckReqVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeCreateReqVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeDisableReqVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeFindAllReqVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeValidateReqVO;
import com.ec.primus.component.model.upgrade.vo.UpgradeValidateRespVO;
import com.ec.primus.component.service.base.service.AbstractComponentService;
import com.ec.primus.component.service.upgrade.dao.po.Upgrade;
import com.ec.primus.component.service.upgrade.dao.repository.UpgradeRepository;
import com.ec.primus.component.service.upgrade.dao.specification.UpgradeFindAllReqVOToSpecification;
import com.ec.primus.component.service.upgrade.transfer.UpgradeCreateReqVOToUpgrade;
import com.ec.primus.component.service.upgrade.transfer.UpgradeToUpgradeVO;
import java.io.Serializable;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UpgradeService
extends AbstractComponentService {
    private final UpgradeRepository upgradeRepository;

    @Autowired
    public UpgradeService(UpgradeRepository upgradeRepository) {
        this.upgradeRepository = upgradeRepository;
    }

    public UpgradeValidateRespVO isValidate(UpgradeValidateReqVO reqVO) {
        AssertUtils.notNull((Object)reqVO, (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null.");
        Long versionScore = this.validateVersionAndGetScore(reqVO.getVersion());
        Integer newerVersion = this.upgradeRepository.countByTypeAndVersionScoreIsGreaterThanEqualAndDeleteFlag(reqVO.getType(), versionScore, Boolean.FALSE);
        UpgradeValidateRespVO result = new UpgradeValidateRespVO();
        result.setIsValidate(Boolean.valueOf(newerVersion == 0));
        if (!result.getIsValidate().booleanValue()) {
            Upgrade newestUpgrade = this.upgradeRepository.findFirstByTypeAndVersionScoreGreaterThanAndDeleteFlagOrderByVersionScoreDesc(reqVO.getType(), versionScore, Boolean.FALSE);
            result.setNewestVersion(newestUpgrade != null ? newestUpgrade.getVersion() : reqVO.getVersion());
        }
        return result;
    }

    public UpgradeVO add(UpgradeCreateReqVO reqVO) throws BizBusinessException {
        AssertUtils.notNull((Object)reqVO, (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null.");
        AssertUtils.notNull((Object)reqVO.getType(), (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.type is null.");
        AssertUtils.notNull((Object)reqVO.getUrl(), (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.url is null.");
        AssertUtils.notNull((Object)reqVO.getIsForce(), (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.isForce is null.");
        Long versionScore = this.validateVersionAndGetScore(reqVO.getVersion());
        Integer newerVersion = this.upgradeRepository.countByTypeAndVersionScoreIsGreaterThanEqualAndDeleteFlag(reqVO.getType(), versionScore, Boolean.FALSE);
        if (newerVersion == 0) {
            Upgrade upgrade = new UpgradeCreateReqVOToUpgrade().apply(reqVO);
            upgrade.setId(this.nextStringId());
            upgrade.setVersionScore(versionScore);
            Upgrade savedUpgrade = (Upgrade)((Object)this.upgradeRepository.save((Object)upgrade));
            return new UpgradeToUpgradeVO().apply(savedUpgrade);
        }
        throw new BizBusinessException((ExceptionType)UpgradeExceptionEnum.UPGRADE_VERSION_EXPIRED);
    }

    public PageResultVO<UpgradeVO> findAll(UpgradeFindAllReqVO reqVO) {
        PageRequest pageRequest = reqVO.toPageRequest();
        PageRequest sortablePageRequest = new PageRequest(pageRequest.getPageNumber(), pageRequest.getPageSize(), Sort.Direction.DESC, new String[]{"versionScore"});
        Page upgradePage = this.upgradeRepository.findAll((Specification)new UpgradeFindAllReqVOToSpecification(reqVO), (Pageable)sortablePageRequest);
        return PageResultVO.ofPages((Page)upgradePage, (Function)new UpgradeToUpgradeVO());
    }

    public UpgradeVO checkUpdate(UpgradeCheckReqVO reqVO) {
        Long versionScore = this.validateVersionAndGetScore(reqVO.getVersion());
        Upgrade newerUpgrade = this.upgradeRepository.findFirstByTypeAndVersionScoreGreaterThanAndDeleteFlagOrderByVersionScoreDesc(reqVO.getType(), versionScore, Boolean.FALSE);
        return newerUpgrade == null ? null : new UpgradeToUpgradeVO().apply(newerUpgrade);
    }

    public void delete(UpgradeDisableReqVO reqVO) {
        Upgrade upgrade = (Upgrade)((Object)this.upgradeRepository.findOne((Serializable)((Object)reqVO.getId())));
        AssertUtils.notNull((Object)((Object)upgrade), (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Upgrade Not Found");
        upgrade.setDeleteFlag(Boolean.TRUE);
        this.upgradeRepository.save((Object)upgrade);
    }

    protected Long validateVersionAndGetScore(String version) {
        AssertUtils.notNull((Object)version, (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument version is null.");
        this.throwIllegalVersionIfFalse(version.matches("^\\d+\\.\\d+\\.\\d+$"));
        String[] versionArray = version.split("\\.");
        Long mainVersion = Long.parseLong(versionArray[0]);
        this.throwIllegalVersionIfFalse(mainVersion < 10000L);
        Long featureVersion = Long.parseLong(versionArray[1]);
        this.throwIllegalVersionIfFalse(featureVersion < 100000L);
        Long bugVersion = Long.parseLong(versionArray[2]);
        this.throwIllegalVersionIfFalse(bugVersion < 10000000L);
        return mainVersion * 10000000000000L + featureVersion * 10000000L + bugVersion;
    }

    private void throwIllegalVersionIfFalse(boolean condition) {
        AssertUtils.isTrue((boolean)condition, (ExceptionType)UpgradeExceptionEnum.ILLEGAL_PARAMETER, (String)"\u65e0\u6548\u7684\u7248\u672c\uff0c\u652f\u6301\u7248\u672c\u683c\u5f0f\u4e3a\"\u6570\u5b57.\u6570\u5b57.\u6570\u5b57\"\uff0c\u4e14\u6700\u5927\u652f\u6301\"9999.99999.9999999\"");
    }
}

