package com.ec.primus.commons.enums;

import java.util.concurrent.TimeUnit;


/**
 * 日期类型枚举值
 *
 * @author ning.zhang
 * @date 2019/9/9
 */
public enum DateTypeEnum {
    /**
     * 天
     */
    DAY("天", TimeUnit.DAYS.toMillis(1L)),

    /**
     * 小时
     */
    HOUR("小时", TimeUnit.HOURS.toMillis(1L)),


    /**
     * 分
     */
    MINUTE("分", TimeUnit.MINUTES.toMillis(1L)),


    /**
     * 秒
     */
    SECOND("秒", TimeUnit.SECONDS.toMillis(1L));

    private final String title;
    private final long millis;

    public String getTitle() {
        return this.title;
    }


    public long getMillis() {
        return this.millis;
    }

    DateTypeEnum(String title, long millis) {
        this.title = title;
        this.millis = millis;
    }


    public static String naturalFormat(long durationMillis) {
        for (DateTypeEnum dateTypeEnum : DateTypeEnum.values()) {
            if (durationMillis >= dateTypeEnum.getMillis()) {
                return durationMillis / dateTypeEnum.getMillis() + dateTypeEnum.getTitle();
            }
        }
        return "刚刚";
    }
}