package com.ec.primus.commons.enums;


import com.ec.primus.commons.enums.converter.BaseEnumValueAndDescriptionConverter;

/**
 * 月份枚举
 *@author ning.zhang
 *@date 2019/9/9
 */
public enum MonthEnum implements ValuableAndDescribableEnum {
    JANUARY("一月", 1),

    FEBRUARY("二月", 2),

    MARCH("三月", 3),

    APRIL("四月", 4),

    MAY("五月", 5),

    JUNE("六月", 6),

    JULY("七月", 7),

    AUGUST("八月", 8),

    SEPTEMBER("九月", 9),

    OCTOBER("十月", 10),

    NOVEMBER("十一月", 11),

    DECEMBER("十二月", 12);

    private String desc;
    private int value;

    private MonthEnum(String desc, int value) {
        this.desc = desc;
        this.value = value;
    }


    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static class Converter
            extends BaseEnumValueAndDescriptionConverter<MonthEnum> {
    }
}