package com.ec.primus.commons.enums;

import com.ec.primus.commons.enums.converter.BaseEnumValueAndDescriptionConverter;

/**
 * 周枚举值
 *
 * @author ning.zhang
 * @date 2019/9/9
 */
public enum WeekEnum implements ValuableAndDescribableEnum {
    SUNDAY("星期天", 1),

    MONDAY("星期一", 2),

    TUESDAY("星期二", 3),

    WEDNESDAY("星期三", 4),

    THURSDAY("星期四", 5),

    FRIDAY("星期五", 6),

    SATURDAY("星期六", 7);

    private String desc;
    private int value;

    WeekEnum(String desc, int value) {
        this.desc = desc;
        this.value = value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static class Converter
            extends BaseEnumValueAndDescriptionConverter<WeekEnum> {
    }
}
