package com.ec.primus.commons.exception;

import org.apache.commons.lang3.StringUtils;


public abstract interface ExceptionType {
    public abstract int getCode();

    public abstract String getDescription();

    default String descriptionWithArgs(Object[] args) {
        if (StringUtils.isNotBlank(getDescription())) {
            return String.format(getDescription(), args);
        }
        return getDescription();
    }
}