package com.ec.primus.commons.utils.bean;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

import java.util.function.Supplier;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;


public class Copier {
    private final Object source;
    private Table<Class, Class, Converter> converterTable = HashBasedTable.create();

    private boolean ignoreNullValue = false;

    private String[] ignoreProperties = new String[0];

    private Copier(Object source) {
        this.source = source;
    }

    public static Copier from(Object source) {
        return new Copier(source);
    }


    public <S, T> Copier usePropertyConverter(Converter<S, T> converter) {
        Assert.notNull(converter, "属性转换器不能为空");
        ResolvableType resolvableType = ResolvableType.forInstance(converter);
        ResolvableType[] generics = resolvableType.getGenerics();
        Assert.isTrue(generics.length == 2, "converter的泛型数量必须为2");
        this.converterTable.put(generics[0].getRawClass(), generics[1].getRawClass(), converter);
        return this;
    }


    public Copier ignoreNullValue() {
        this.ignoreNullValue = true;
        return this;
    }


    public Copier ignoreProperties(String... propertyNames) {
        this.ignoreProperties = ((String[]) ArrayUtils.clone(propertyNames));
        return this;
    }

    public <T> T to(T target) {
        Assert.notNull(target, "target不能为null");
        return (T) CopyUtils.copyProperties(this.source, target, this.ignoreNullValue, this.converterTable, this.ignoreProperties);
    }

    public <T> T to(Supplier<T> supplier) {
        Assert.notNull(supplier, "supplier不能为null");
        return (T) to(supplier.get());
    }
}