package com.ec.primus.commons.utils.security;

import com.ec.primus.commons.exception.security.AesEncryptException;
import com.ec.primus.commons.exception.security.AesDecryptException;

import java.io.UnsupportedEncodingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;


public class AesCryptographer {
    public static final String ENCODING = "UTF-8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

    public byte[] cbcEncrypt(byte[] content, String password, String ivParam)
            throws AesEncryptException {
        try {
            Cipher cipher = getAesCbcCipher();
            cipher.init(1, getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes("UTF-8")));
            return cipher.doFinal(content);
        } catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }


    public byte[] cbcEncrypt(String content, String password, String ivParam)
            throws AesEncryptException {
        try {
            return cbcEncrypt(content.getBytes("UTF-8"), password, ivParam);
        } catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }


    public byte[] ecbEncrypt(String content, String secretKey)
            throws AesEncryptException {
        try {
            Cipher cipher = getAesEcbCipher();
            cipher.init(1, getAesSecretKeySpec(secretKey));
            return cipher.doFinal(content.getBytes("UTF-8"));
        } catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }


    public byte[] cbcDecrypt(byte[] encryptedContent, String password, String ivParam)
            throws AesDecryptException {
        try {
            Cipher cipher = getAesCbcCipher();
            cipher.init(2, getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes("UTF-8")));
            return cipher.doFinal(encryptedContent);
        } catch (Exception e) {
            throw new AesDecryptException(e);
        }
    }


    public byte[] ebcDecrypt(byte[] encryptedContent, String password)
            throws AesDecryptException {
        try {
            Cipher cipher = getAesEcbCipher();
            cipher.init(2, getAesSecretKeySpec(password));
            return cipher.doFinal(encryptedContent);
        } catch (Exception e) {
            throw new AesDecryptException(e);
        }
    }

    private Cipher getAesEcbCipher() {
        try {
            AES_ECB_THREADLOCAL.set(Cipher.getInstance("AES/ECB/PKCS5Padding"));
        } catch (Exception e) {
            throw new AesEncryptException(e);
        }
        return (Cipher) AES_ECB_THREADLOCAL.get();
    }

    private Cipher getAesCbcCipher() {
        try {
            AES_CBC_THREADLOCAL.set(Cipher.getInstance("AES/CBC/PKCS5Padding"));
        } catch (Exception e) {
            throw new AesEncryptException(e);
        }
        return (Cipher) AES_CBC_THREADLOCAL.get();
    }


    private SecretKeySpec getAesSecretKeySpec(String password)
            throws UnsupportedEncodingException {
        return new SecretKeySpec(password.getBytes("UTF-8"), "AES");
    }


    private static ThreadLocal<Cipher> AES_ECB_THREADLOCAL = new ThreadLocal<>();

    private static ThreadLocal<Cipher> AES_CBC_THREADLOCAL = new ThreadLocal<>();
}