package com.ec.primus.commons.utils.text;

import com.google.common.collect.Lists;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public class CsvUtils {
    public static List<String[]> read(File file) {
        String cvsSplitBy = ",";
        List<String[]> result = Lists.newArrayList();
        try {
            BufferedReader br = new BufferedReader(new java.io.FileReader(file));
            Throwable localThrowable3 = null;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    result.add(line.split(cvsSplitBy));
                }
            } catch (Throwable localThrowable1) {
                localThrowable3 = localThrowable1;
                throw localThrowable1;

            } finally {
                if (localThrowable3 != null) {
                    try {
                        br.close();
                    } catch (Throwable localThrowable2) {
                        localThrowable3.addSuppressed(localThrowable2);
                    }
                } else {
                    br.close();
                }
            }
        } catch (IOException e) {
            String line;
            throw new RuntimeException(e);
        }
        String line;
        return result;
    }

    public static void write(List<String[]> data, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable localThrowable3 = null;
            try {
                write(data, fileOutputStream);
            } catch (Throwable localThrowable1) {
                localThrowable3 = localThrowable1;
                throw localThrowable1;
            } finally {
                if (localThrowable3 != null) {
                    try {
                        fileOutputStream.close();
                    } catch (Throwable localThrowable2) {
                        localThrowable3.addSuppressed(localThrowable2);
                    }
                } else {
                    fileOutputStream.close();
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(List<String[]> data, OutputStream os) {
        byte[] commonCsvHead = {-17, -69, -65};
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, "UTF-8");
            PrintWriter fileWriter = new PrintWriter(outputStreamWriter);
            fileWriter.write(new String(commonCsvHead));
            for (String[] dataArray : data) {
                fileWriter.write(StringUtils.join(dataArray, ","));
                fileWriter.write("\n");
                fileWriter.flush();
            }
            fileWriter.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}