package com.ec.primus.commons.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

import java.io.Serializable;

/**
 * 基础分页对象
 *@author ning.zhang
 *@date 2019/9/16
 */
@ApiModel("基础分页对象")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class PageRequestVO implements Serializable {
    private static final long serialVersionUID = -7408530622119545340L;

    @ApiModelProperty("页码1开始")
    private int page = 1;

    @ApiModelProperty("分页大小默认20")
    private int size = 20;

    public PageRequest toPageRequest() {
        return PageRequest.of(page, size);
    }

    public PageRequest toPageRequest(Sort sort) {
        return PageRequest.of(page, size, sort);
    }

    public PageRequest buildPageRequest(Sort sort) {
        return PageRequest.of(Math.max(0, page - 1), size, sort);
    }
}
