package com.ec.primus.commons.vo;

import com.ec.primus.commons.exception.BusinessParameterException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

/**
 * @author yanweijin
 * @date 2017/9/14
 */
@Data
@AllArgsConstructor(staticName = "of")
@NoArgsConstructor
public class PageResultVO<T> {

    private Integer currentPage = 0;

    private Integer totalPage = 1;

    private Long totalSize = 0L;

    private List<T> content = Collections.emptyList();

    public Boolean hasNext() {
        return currentPage < totalPage - 1;
    }

    public static <S, T> PageResultVO<T> ofPages(Page<S> page, List<T> content) {
        PageResultVO<T> result = new PageResultVO<>();
        result.setContent(content);
        result.setCurrentPage(page.getNumber());
        result.setTotalPage(page.getTotalPages());
        result.setTotalSize(page.getTotalElements());
        return result;
    }

    public static <T> PageResultVO<T> ofPages(Page<T> page) {
        PageResultVO<T> result = new PageResultVO<>();
        result.setContent(page.getContent());
        result.setCurrentPage(page.getNumber());
        result.setTotalPage(page.getTotalPages());
        result.setTotalSize(page.getTotalElements());
        return result;
    }

    public static <T,S> PageResultVO<T> ofPages(Page<S> page, Function<S, T> applyFunction){

        PageResultVO<T> pageResultVO = new PageResultVO<>();
        if(page != null){
            if(applyFunction == null){
                throw new BusinessParameterException("Argument applyFunction is null");
            }
            //Lists.transform生成的list无法被修改
            ArrayList<T> list = Lists.newArrayList(ImmutableList.copyOf(Lists.transform(page.getContent(), applyFunction::apply)));
            pageResultVO.setContent(list);
            pageResultVO.setCurrentPage(page.getNumber());
            pageResultVO.setTotalPage(page.getTotalPages());
            pageResultVO.setTotalSize(page.getTotalElements());
        }
        return pageResultVO;
    }
}
