/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.enums;

import java.util.concurrent.TimeUnit;

public enum DateTypeEnum {
    DAY("\u5929", TimeUnit.DAYS.toMillis(1L)),
    HOUR("\u5c0f\u65f6", TimeUnit.HOURS.toMillis(1L)),
    MINUTE("\u5206", TimeUnit.MINUTES.toMillis(1L)),
    SECOND("\u79d2", TimeUnit.SECONDS.toMillis(1L));

    private final String title;
    private final long millis;

    public String getTitle() {
        return this.title;
    }

    public long getMillis() {
        return this.millis;
    }

    private DateTypeEnum(String title, long millis) {
        this.title = title;
        this.millis = millis;
    }

    public static String naturalFormat(long durationMillis) {
        for (DateTypeEnum dateTypeEnum : DateTypeEnum.values()) {
            if (durationMillis < dateTypeEnum.getMillis()) continue;
            return durationMillis / dateTypeEnum.getMillis() + dateTypeEnum.getTitle();
        }
        return "\u521a\u521a";
    }
}

