/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static final String JSON_DESERIALIZE_ERROR_MSG = "Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519";
    public static final String JSON_SERIALIZE_ERROR_MSG = "Json\u5e8f\u5217\u5316\u51fa\u9519";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

    public static Object json2Obj(String jsonStr) {
        return JsonUtils.json2Obj(jsonStr, Object.class);
    }

    public static <T> T json2Obj(String jsonStr, Class<T> clazz) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception var3) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, var3);
        }
    }

    public static void writeJson2Obj2OutputStream(Object content, OutputStream outputStream) {
        if (!Objects.isNull(content)) {
            try {
                OBJECT_MAPPER.writeValue(outputStream, content);
            }
            catch (Exception var3) {
                throw new RuntimeException(JSON_SERIALIZE_ERROR_MSG, var3);
            }
        }
    }

    public static <T> T json2Obj(String content, Class<T> clazzItem, Class ... classes) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception var5) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, var5);
        }
    }

    public static <K, V> Map<K, V> json2Map(String content, Class<K> keyCls, Class<V> valueCls) {
        Map jsonMap = JsonUtils.json2Obj(content, Map.class);
        if (jsonMap == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        jsonMap.forEach((key, value) -> {
            Object keyObj = JsonUtils.json2Obj(key, keyCls);
            Object valueObj = JsonUtils.json2Obj(value.toString(), valueCls);
            result.put(keyObj, valueObj);
        });
        return result;
    }

    public static String obj2Json(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception var2) {
            throw new RuntimeException(JSON_SERIALIZE_ERROR_MSG, var2);
        }
    }
}

