/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.utils.ValueUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Stopwatch {
    private static final Logger log = LoggerFactory.getLogger(Stopwatch.class);
    private StopWatch sw = new StopWatch();
    private Map<String, Long> map = Maps.newLinkedHashMap();
    private long preTime = 0L;
    private boolean enabled = true;
    private Logger privateLogger = null;

    public static Stopwatch createAndBegin(boolean enabled) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.enabled = enabled;
        if (!enabled) {
            return stopwatch;
        }
        stopwatch.sw.start();
        return stopwatch;
    }

    public static Stopwatch createAndBegin(Logger logger) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.privateLogger = logger;
        stopwatch.enabled = logger.isDebugEnabled();
        if (!stopwatch.enabled) {
            return stopwatch;
        }
        stopwatch.sw.start();
        return stopwatch;
    }

    public void start() throws BusinessSilentException {
        if (this.enabled) {
            throw new BusinessSilentException("Stopwatch already started.");
        }
        this.enabled = true;
        this.sw.start();
    }

    public void record(String tag) {
        if (!this.enabled) {
            return;
        }
        this.sw.split();
        long splitTime = this.sw.getSplitTime();
        long sub = splitTime - this.preTime;
        this.map.put(tag, sub);
        this.preTime = splitTime;
    }

    private Map<String, Long> out() {
        if (!this.enabled || this.sw.isStopped()) {
            return this.map;
        }
        this.sw.stop();
        long all = this.sw.getTime();
        this.map.put("\u603b\u8ba1\u7528\u65f6", all);
        return this.map;
    }

    public void print(String tag) {
        this.print(Level.DEBUG, tag);
    }

    public void print(Level logLevel, String tag) {
        if (!this.enabled) {
            return;
        }
        switch (logLevel) {
            case DEBUG: {
                this.getLogger().debug(tag + " {}", this.out());
                break;
            }
            case INFO: {
                this.getLogger().info(tag + " {}", this.out());
                break;
            }
            case WARN: {
                this.getLogger().warn(tag + " {}", this.out());
                break;
            }
            case ERROR: {
                this.getLogger().error(tag + " {}", this.out());
                break;
            }
            default: {
                this.getLogger().trace(tag + " {}", this.out());
            }
        }
    }

    private Logger getLogger() {
        return ValueUtils.getValueOrDefault(this.privateLogger, log);
    }
}

