/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils.security;

import com.ec.primus.commons.exception.security.AesDecryptException;
import com.ec.primus.commons.exception.security.AesEncryptException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCryptographer {
    public static final String ENCODING = "UTF-8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";
    private static ThreadLocal<Cipher> AES_ECB_THREADLOCAL = new ThreadLocal();
    private static ThreadLocal<Cipher> AES_CBC_THREADLOCAL = new ThreadLocal();

    public byte[] cbcEncrypt(byte[] content, String password, String ivParam) throws AesEncryptException {
        try {
            Cipher cipher = this.getAesCbcCipher();
            cipher.init(1, (Key)this.getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes(ENCODING)));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }

    public byte[] cbcEncrypt(String content, String password, String ivParam) throws AesEncryptException {
        try {
            return this.cbcEncrypt(content.getBytes(ENCODING), password, ivParam);
        }
        catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }

    public byte[] ecbEncrypt(String content, String secretKey) throws AesEncryptException {
        try {
            Cipher cipher = this.getAesEcbCipher();
            cipher.init(1, this.getAesSecretKeySpec(secretKey));
            return cipher.doFinal(content.getBytes(ENCODING));
        }
        catch (Exception e) {
            throw new AesEncryptException(e);
        }
    }

    public byte[] cbcDecrypt(byte[] encryptedContent, String password, String ivParam) throws AesDecryptException {
        try {
            Cipher cipher = this.getAesCbcCipher();
            cipher.init(2, (Key)this.getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes(ENCODING)));
            return cipher.doFinal(encryptedContent);
        }
        catch (Exception e) {
            throw new AesDecryptException(e);
        }
    }

    public byte[] ebcDecrypt(byte[] encryptedContent, String password) throws AesDecryptException {
        try {
            Cipher cipher = this.getAesEcbCipher();
            cipher.init(2, this.getAesSecretKeySpec(password));
            return cipher.doFinal(encryptedContent);
        }
        catch (Exception e) {
            throw new AesDecryptException(e);
        }
    }

    private Cipher getAesEcbCipher() {
        try {
            AES_ECB_THREADLOCAL.set(Cipher.getInstance(CIPHER_ALGORITHM_ECB));
        }
        catch (Exception e) {
            throw new AesEncryptException(e);
        }
        return AES_ECB_THREADLOCAL.get();
    }

    private Cipher getAesCbcCipher() {
        try {
            AES_CBC_THREADLOCAL.set(Cipher.getInstance(CIPHER_ALGORITHM_CBC));
        }
        catch (Exception e) {
            throw new AesEncryptException(e);
        }
        return AES_CBC_THREADLOCAL.get();
    }

    private SecretKeySpec getAesSecretKeySpec(String password) throws UnsupportedEncodingException {
        return new SecretKeySpec(password.getBytes(ENCODING), KEY_ALGORITHM);
    }
}

