/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.vo;

import com.ec.primus.commons.exception.BusinessParameterException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;

public class PageResultVO<T> {
    private Integer currentPage = 0;
    private Integer totalPage = 1;
    private Long totalSize = 0L;
    private List<T> content = Collections.emptyList();

    public Boolean hasNext() {
        return this.currentPage < this.totalPage - 1;
    }

    public static <S, T> PageResultVO<T> ofPages(Page<S> page, List<T> content) {
        PageResultVO<T> result = new PageResultVO<T>();
        result.setContent(content);
        result.setCurrentPage(page.getNumber());
        result.setTotalPage(page.getTotalPages());
        result.setTotalSize(page.getTotalElements());
        return result;
    }

    public static <T> PageResultVO<T> ofPages(Page<T> page) {
        PageResultVO<T> result = new PageResultVO<T>();
        result.setContent(page.getContent());
        result.setCurrentPage(page.getNumber());
        result.setTotalPage(page.getTotalPages());
        result.setTotalSize(page.getTotalElements());
        return result;
    }

    public static <T, S> PageResultVO<T> ofPages(Page<S> page, Function<S, T> applyFunction) {
        PageResultVO<T> pageResultVO = new PageResultVO<T>();
        if (page != null) {
            if (applyFunction == null) {
                throw new BusinessParameterException("Argument applyFunction is null");
            }
            ArrayList list = Lists.newArrayList((Iterable)ImmutableList.copyOf((Collection)Lists.transform((List)page.getContent(), applyFunction::apply)));
            pageResultVO.setContent(list);
            pageResultVO.setCurrentPage(page.getNumber());
            pageResultVO.setTotalPage(page.getTotalPages());
            pageResultVO.setTotalSize(page.getTotalElements());
        }
        return pageResultVO;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Long getTotalSize() {
        return this.totalSize;
    }

    public List<T> getContent() {
        return this.content;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void setTotalSize(Long totalSize) {
        this.totalSize = totalSize;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResultVO)) {
            return false;
        }
        PageResultVO other = (PageResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Long this$totalSize = this.getTotalSize();
        Long other$totalSize = other.getTotalSize();
        if (this$totalSize == null ? other$totalSize != null : !((Object)this$totalSize).equals(other$totalSize)) {
            return false;
        }
        List<T> this$content = this.getContent();
        List<T> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Long $totalSize = this.getTotalSize();
        result = result * 59 + ($totalSize == null ? 43 : ((Object)$totalSize).hashCode());
        List<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "PageResultVO(currentPage=" + this.getCurrentPage() + ", totalPage=" + this.getTotalPage() + ", totalSize=" + this.getTotalSize() + ", content=" + this.getContent() + ")";
    }

    private PageResultVO(Integer currentPage, Integer totalPage, Long totalSize, List<T> content) {
        this.currentPage = currentPage;
        this.totalPage = totalPage;
        this.totalSize = totalSize;
        this.content = content;
    }

    public static <T> PageResultVO<T> of(Integer currentPage, Integer totalPage, Long totalSize, List<T> content) {
        return new PageResultVO<T>(currentPage, totalPage, totalSize, content);
    }

    public PageResultVO() {
    }
}

