package com.ec.primus.commons.enums.converter;

import com.ec.primus.commons.enums.ValuableEnum;

import java.lang.reflect.Method;
import javax.persistence.AttributeConverter;

/**
 * 枚举属性转换器基类,将枚举的value转换为数据库的int值
 *@author ning.zhang
 *@date 2019/9/9
 */
public abstract class BaseEnumValueConverter<E extends ValuableEnum>
        implements AttributeConverter<E, Integer> {
    private Class<E> clz;
    private Method method;

    @Override
    public Integer convertToDatabaseColumn(ValuableEnum attribute) {
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public E convertToEntityAttribute(Integer dbData) {
        return valueOf(dbData);
    }

    @SuppressWarnings("unchecked")
    public BaseEnumValueConverter() {
        try {
            this.clz = ((Class) ((java.lang.reflect.ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
            this.method = this.clz.getMethod("values");
        } catch (Exception e) {
            throw new RuntimeException("反射失败", e);
        }
    }

    /**
     * 根据value获取对应枚举
     *
     * @param value
     * @return
     */
    @SuppressWarnings("unchecked")
    public E valueOf(Integer value) {
        if (value == null) {
            return null;
        }
        try {
            this.method = this.clz.getMethod("values");
            for (E e : (E[]) this.method.invoke(null)) {
                if (e.getValue() == value) {
                    return e;
                }
            }
            return null;
        } catch (Exception e) {
            throw new RuntimeException("反射失败", e);
        }
    }
}