package com.ec.primus.commons.jackson.annotation;

import com.ec.primus.commons.jackson.serialize.SensitiveFieldJsonSerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({java.lang.annotation.ElementType.METHOD, java.lang.annotation.ElementType.FIELD})
@JacksonAnnotationsInside
@JsonSerialize(using = SensitiveFieldJsonSerializer.class)
public @interface SensitiveField {
}