package com.ec.primus.commons.support.jackson;

import com.ec.primus.commons.utils.DateUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.time.LocalDateTime;


public class PrimusLocalDateTimeSerializer
        extends JsonSerializer<LocalDateTime> {
    @Override
    public void serialize(LocalDateTime dateTime, JsonGenerator gen, SerializerProvider serializers)
            throws IOException {
        String formattedDateTime = DateUtils.format2String(dateTime);
        gen.writeString(formattedDateTime);
    }
}