package com.ec.primus.commons.support.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;


public class PrimusLocalTimeSerializer
        extends JsonSerializer<LocalTime> {
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    public void serialize(LocalTime time, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String formattedDateTime = time.format(this.formatter);
        gen.writeString(formattedDateTime);
    }
}