package com.ec.primus.commons.support.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;


@ConditionalOnProperty(value = {"primus.security.cors.enable"}, havingValue = "true")
@Configuration
public class CorsConfig {
    private static final Logger log = LoggerFactory.getLogger(CorsConfig.class);

    @Value("${primus.security.cors.pathPattern:/**}")
    private String pathPattern;

    @Value("${primus.security.cors.allowedHeaders:*}")
    private String allowedHeaders;

    @Value("${primus.security.cors.allowedMethods:*}")
    private String allowedMethods;

    @Value("${primus.security.cors.allowedOrigins:*}")
    private String allowedOrigins;


    @Bean
    public FilterRegistrationBean corsFilter() {
        log.info("Add CORS configuration pathPattern:{}, allowedHeaders:{}, allowedMethods:{}, allowedOrigins:{}", this.pathPattern, this.allowedHeaders, this.allowedMethods, this.allowedOrigins);

        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.TRUE);
        config.addAllowedOrigin(this.allowedOrigins);
        config.addAllowedHeader(this.allowedHeaders);
        config.addAllowedMethod(this.allowedMethods);
        source.registerCorsConfiguration(this.pathPattern, config);
        FilterRegistrationBean bean = new FilterRegistrationBean(new CorsFilter(source), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }
}