package com.ec.primus.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import com.ec.primus.commons.exception.GzipException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;


public class GzipUtils {
    public static int BUFFER_SIZE = 256;


    public static byte[] compress(byte[] data) {
        if (ArrayUtils.isEmpty(data)) {
            return data;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
            return out.toByteArray();
        } catch (IOException e) {
            throw new GzipException("Gzip compress failed.", e);
        }
    }


    public static byte[] compress(String data) {
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        return compress(getBytes(data));
    }

    private static byte[] getBytes(String data) {
        try {
            return data.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new GzipException("不支持的字符集", e);
        }
    }


    public static byte[] decompress(byte[] data) {
        if (ArrayUtils.isEmpty(data)) {
            return data;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream gzipInputStream = new GZIPInputStream(in);
            byte[] buffer = new byte[BUFFER_SIZE];
            int n;
            while ((n = gzipInputStream.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            gzipInputStream.close();
            in.close();
            return out.toByteArray();
        } catch (IOException e) {
            throw new GzipException("Gzip compress failed.", e);
        }
    }
}