package com.ec.primus.commons.utils;

import java.io.*;
import java.net.URL;


public class IOUtils {
    private static final int ONE_KILOBYTE_SIZE = 1024;
    private static final int BUFFER_SIZE = 32768;

    public static InputStream getInputStreamFromNetwork(String targetURL)
            throws IOException {
        return new URL(targetURL).openConnection().getInputStream();
    }

    public static byte[] getBytesFromNetwork(String targetURL) throws IOException {
        return getBytes(getInputStreamFromNetwork(targetURL));
    }


    public static byte[] getBytes(InputStream sourceInputStream)
            throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[32768];
        for (int len = 0; (len = sourceInputStream.read(buffer)) != -1; ) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        byte[] arrayOfByte = byteArrayOutputStream.toByteArray();
        return arrayOfByte;
    }


    public static boolean write(InputStream sourceInputStream, OutputStream destinationOutputStream)
            throws IOException {
        byte[] buffer = buildBuffer(32768);
        for (int len = 0; (len = sourceInputStream.read(buffer)) != -1; ) {
            destinationOutputStream.write(buffer, 0, len);
        }
        destinationOutputStream.flush();
        return true;
    }


    public static boolean write(byte[] sourceBytes, OutputStream destinationOutputStream)
            throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(destinationOutputStream);
        bufferedOutputStream.write(sourceBytes, 0, sourceBytes.length);
        bufferedOutputStream.flush();
        return true;
    }

    private static byte[] buildBuffer(int bufferSize) {
        return new byte[bufferSize];
    }
}