package com.ec.primus.commons.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ValueAllocator {
    private static final Logger log = LoggerFactory.getLogger(ValueAllocator.class);
    private final double totalForAllocation;

    public double getTotalForAllocation() {
        return this.totalForAllocation;
    }

    private int undistributedValue;

    public int getUndistributedValue() {
        return this.undistributedValue;
    }

    public int getAllocationCounter() {
        return this.allocationCounter;
    }
    private int allocationCounter = 0;
    private final int expectAllocationCount;

    public int getExpectAllocationCount() {
        return this.expectAllocationCount;
    }
    public ValueAllocator(Integer totalForAllocation, int expectAllocationCount, String mark) {
        this.totalForAllocation = ValueUtils.getValue(totalForAllocation);
        this.undistributedValue = ValueUtils.getValue(totalForAllocation);
        this.expectAllocationCount = expectAllocationCount;
        this.mark = mark;
    }


    private String mark;


    public synchronized int allocate(double rate) {
        int expectAmount = (int) (rate * this.totalForAllocation);
        if (log.isTraceEnabled()) {
            log.trace("值分摊器[{}]: 数值分配中, 需求比例={}, 总计可分配值={}, 本次应分配值={}", new Object[]{this.mark, Double.valueOf(rate), Double.valueOf(this.totalForAllocation), Integer.valueOf(expectAmount)});
        }
        this.allocationCounter += 1;
        if (this.allocationCounter > this.expectAllocationCount) {
            log.warn("值分摊器[{}]: 数值分配错误, 当前分配计数器大于了总共期望分配的次数{},请检查代码", this.mark, Integer.valueOf(this.expectAllocationCount));
            return 0;
        }
        if (this.allocationCounter == this.expectAllocationCount) {
            return this.undistributedValue;
        }
        if (this.undistributedValue - expectAmount < 0) {
            int temp = this.undistributedValue;
            this.undistributedValue = 0;
            log.warn("值分摊器[{}]: 数值早于预期的分配完毕,请检查数据是否正确", this.mark);
            return temp;
        }
        this.undistributedValue -= expectAmount;
        return expectAmount;
    }
}