package com.ec.primus.commons.utils.bean;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import org.springframework.util.Assert;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;


public class GenericClassUtils {
    public static Class getGenericTypeFromInterface(Class targetClass, int index) {
        return getGenericTypeFromInterface(targetClass, null, index);
    }


    public static Class getGenericTypeFromInterface(Class targetClass, Class interfaceClass, int index) {
        Type[] genericInterfaces = targetClass.getGenericInterfaces();

        for (Type genericInterface : genericInterfaces) {
            if (((genericInterface instanceof ParameterizedType)) && (
                    (interfaceClass == null) || (((ParameterizedTypeImpl) genericInterface).getRawType().equals(interfaceClass)))) {
                ParameterizedType parameterizedType = (ParameterizedType) genericInterface;
                return getActualTypeArgumentClass(parameterizedType, index);
            }
        }

        return Object.class;
    }


    public static Class getGenericTypeFromSuperClass(Class targetClass, int index) {
        Type superType = targetClass.getGenericSuperclass();

        if ((superType instanceof ParameterizedType)) {
            ParameterizedType parameterizedType = (ParameterizedType) superType;
            return getActualTypeArgumentClass(parameterizedType, index);
        }
        return Object.class;
    }

    private static Class getActualTypeArgumentClass(ParameterizedType parameterizedType, int index) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Assert.isTrue(actualTypeArguments.length > index, "Number of type arguments must be great or equals " + index);
        return (Class) actualTypeArguments[index];
    }
}