package com.ec.primus.commons.utils.geo;


public class DistanceCalculator {
    private static double PI = 3.141592653589793D;
    private static double TWOPI = 6.283185307179586D;
    private static double DE2RA = 0.01745329252D;
    private static double RA2DE = 57.2957795129D;
    private static double ERAD = 6378.135D;
    private static double ERADM = 6378135.0D;
    private static double AVG_ERAD = 6371.0D;
    private static double FLATTENING = 0.0033528106647474805D;

    private static double EPS = 5.0E-12D;
    private static double KM2MI = 0.621371D;
    private static double GEOSTATIONARY_ALT = 35786.0D;

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        lat1 = DE2RA * lat1;
        lon1 = -DE2RA * lon1;
        lat2 = DE2RA * lat2;
        lon2 = -DE2RA * lon2;

        double F = (lat1 + lat2) / 2.0D;
        double G = (lat1 - lat2) / 2.0D;
        double L = (lon1 - lon2) / 2.0D;

        double sing = Math.sin(G);
        double cosl = Math.cos(L);
        double cosf = Math.cos(F);
        double sinl = Math.sin(L);
        double sinf = Math.sin(F);
        double cosg = Math.cos(G);

        double S = sing * sing * cosl * cosl + cosf * cosf * sinl * sinl;
        double C = cosg * cosg * cosl * cosl + sinf * sinf * sinl * sinl;
        double W = Math.atan2(Math.sqrt(S), Math.sqrt(C));
        double R = Math.sqrt(S * C) / W;
        double H1 = (3.0D * R - 1.0D) / (2.0D * C);
        double H2 = (3.0D * R + 1.0D) / (2.0D * S);
        double D = 2.0D * W * ERAD;
        return D * (1.0D + FLATTENING * H1 * sinf * sinf * cosg * cosg - FLATTENING * H2 * cosf * cosf * sing * sing) * 1000.0D;
    }
}