package com.ec.primus.commons.vo;

import com.ec.primus.commons.exception.BusinessException;
import com.ec.primus.commons.exception.CommonExceptions;
import com.ec.primus.commons.exception.ExceptionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(description = "RPC调用结果")
public class JSONResult {
    @ApiModelProperty(value = "服务器RPC响应code", example = "200")
    private int code;
    @ApiModelProperty(value = "执行结果描述", example = "success")
    private String msg;
    @ApiModelProperty(value = "服务器结果返回时的 Unix timestamp,单位毫秒", example = "1356019200000")
    private long ts;
    @ApiModelProperty(value = "响应结果", example = "{}")
    private Object data;

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public long getTs() {
        return this.ts;
    }

    public JSONResult() {
        this.code = 200;


        this.msg = "success";


        this.ts = System.currentTimeMillis();
    }

    public Object getData() {
        return this.data;
    }

    public JSONResult(int code, String msg) {
        this.code = 200;


        this.msg = "success";


        this.ts = System.currentTimeMillis();


        this.code = code;
        this.msg = msg;
    }

    public JSONResult(int code, String msg, Object data) {
        this.code = 200;


        this.msg = "success";


        this.ts = System.currentTimeMillis();


        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public JSONResult(Object data) {
        this.code = 200;


        this.msg = "success";


        this.ts = System.currentTimeMillis();


        this.data = data;
    }

    public JSONResult(ExceptionType exceptionType) {
        this(exceptionType.getCode(), exceptionType.getDescription());
    }

    public JSONResult(BusinessException bisinessException) {
        this(bisinessException.getCode(), bisinessException.getDescription());
    }

    public static JSONResult of(Exception ex) {
        if ((ex instanceof BusinessException)) {
            return new JSONResult(ex);
        }
        return new JSONResult(CommonExceptions.SERVER_ERROR.getCode(), ex.getMessage());
    }
}