/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class PrimusLocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    private static final DateTimeFormatter PRIMUS_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)p.getText())) {
            String text = p.getText().trim();
            return LocalDateTime.from(PRIMUS_DATETIME_FORMATTER.parse(text));
        }
        return null;
    }
}

