/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils;

import com.ec.primus.commons.constant.DatePeriod;
import com.ec.primus.commons.exception.DateException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final String DEFAULT_DATE_SIMPLE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_24HOUR_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> simpleDateFormatCache = new ThreadLocal();
    private static final ThreadLocal<Calendar> calendarCache = new ThreadLocal();

    public static Date getDateFromString(String dateString) {
        return DateUtils.getDateFromString(dateString, DEFAULT_DATETIME_24HOUR_PATTERN);
    }

    public static Date getDateFromString(String dateString, String pattern) {
        try {
            SimpleDateFormat df = DateUtils.buildDateFormat(pattern);
            return df.parse(dateString);
        }
        catch (ParseException e) {
            throw new DateException(String.format("Could not parse %s with pattern %s.", dateString, pattern), e);
        }
    }

    public static String getDateFormat(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = DateUtils.buildDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static String getDateFormat(String date, String datePattern, String formatPattern) {
        Date parsedDate = DateUtils.getDateFromString(date, datePattern);
        SimpleDateFormat simpleDateFormat = DateUtils.buildDateFormat(formatPattern);
        return simpleDateFormat.format(parsedDate);
    }

    public static Date getDateOfSecondsBack(int secondsBack, Date date) {
        return DateUtils.dateBack(13, secondsBack, date);
    }

    public static Date getDateOfMinutesBack(int minutesBack, Date date) {
        return DateUtils.dateBack(12, minutesBack, date);
    }

    public static Date getDateOfHoursBack(int hoursBack, Date date) {
        return DateUtils.dateBack(11, hoursBack, date);
    }

    public static Date getDateOfDaysBack(int daysBack, Date date) {
        return DateUtils.dateBack(5, daysBack, date);
    }

    public static Date getDateOfWeeksBack(int weeksBack, Date date) {
        return DateUtils.dateBack(4, weeksBack, date);
    }

    public static Date getDateOfMonthsBack(int monthsBack, Date date) {
        return DateUtils.dateBack(2, monthsBack, date);
    }

    public static Date getDateOfYearsBack(int yearsBack, Date date) {
        return DateUtils.dateBack(1, yearsBack, date);
    }

    public static int getSecondOfMinute(Date date) {
        return DateUtils.getNumberOfGranularity(13, date);
    }

    public static int getMinuteOfHour(Date date) {
        return DateUtils.getNumberOfGranularity(12, date);
    }

    public static int getHourOfDay(Date date) {
        return DateUtils.getNumberOfGranularity(11, date);
    }

    public static int getDayOfWeek(Date date) {
        return DateUtils.getNumberOfGranularity(7, date);
    }

    public static int getDayOfMonth(Date date) {
        return DateUtils.getNumberOfGranularity(5, date);
    }

    public static int getDayOfYear(Date date) {
        return DateUtils.getNumberOfGranularity(6, date);
    }

    public static int getWeekOfMonth(Date date) {
        return DateUtils.getNumberOfGranularity(4, date);
    }

    public static int getWeekOfYear(Date date) {
        return DateUtils.getNumberOfGranularity(3, date);
    }

    public static int getMonthOfYear(Date date) {
        return DateUtils.getNumberOfGranularity(2, date) + 1;
    }

    public static int getYear(Date date) {
        return DateUtils.getNumberOfGranularity(1, date);
    }

    public static boolean isFirstDayOfTheMonth(Date date) {
        return DateUtils.getDayOfMonth(date) == 1;
    }

    public static boolean isLastDayOfTheMonth(Date date) {
        Date dateOfMonthsBack = DateUtils.getDateOfMonthsBack(-1, date);
        int dayOfMonth = DateUtils.getDayOfMonth(dateOfMonthsBack);
        Date dateOfDaysBack = DateUtils.getDateOfDaysBack(dayOfMonth, dateOfMonthsBack);
        return dateOfDaysBack.equals(date);
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date buildDate(long times) {
        return new Date(times);
    }

    public static long subSeconds(Date date1, Date date2) {
        return DateUtils.subTime(date1, date2, DatePeriod.SECOND);
    }

    public static long subMinutes(Date date1, Date date2) {
        return DateUtils.subTime(date1, date2, DatePeriod.MINUTE);
    }

    public static long subHours(Date date1, Date date2) {
        return DateUtils.subTime(date1, date2, DatePeriod.HOUR);
    }

    public static long subDays(String dateString1, String dateString2) {
        Date date1 = DateUtils.getDateFromString(dateString1, DEFAULT_DATE_SIMPLE_PATTERN);
        Date date2 = DateUtils.getDateFromString(dateString2, DEFAULT_DATE_SIMPLE_PATTERN);
        return DateUtils.subDays(date1, date2);
    }

    public static long subDays(Date date1, Date date2) {
        return DateUtils.subTime(date1, date2, DatePeriod.DAY);
    }

    public static long subMonths(String dateString1, String dateString2) {
        Date date1 = DateUtils.getDateFromString(dateString1, DEFAULT_DATE_SIMPLE_PATTERN);
        Date date2 = DateUtils.getDateFromString(dateString2, DEFAULT_DATE_SIMPLE_PATTERN);
        return DateUtils.subMonths(date1, date2);
    }

    public static long subMonths(Date date1, Date date2) {
        Calendar calendar1 = DateUtils.buildCalendar(date1);
        int monthOfDate1 = calendar1.get(2);
        int yearOfDate1 = calendar1.get(1);
        Calendar calendar2 = DateUtils.buildCalendar(date2);
        int monthOfDate2 = calendar2.get(2);
        int yearOfDate2 = calendar2.get(1);
        int subMonth = Math.abs(monthOfDate1 - monthOfDate2);
        int subYear = Math.abs(yearOfDate1 - yearOfDate2);
        return subYear * 12 + subMonth;
    }

    public static long subYears(String dateString1, String dateString2) {
        Date date1 = DateUtils.getDateFromString(dateString1, DEFAULT_DATE_SIMPLE_PATTERN);
        Date date2 = DateUtils.getDateFromString(dateString2, DEFAULT_DATE_SIMPLE_PATTERN);
        return DateUtils.subMonths(date1, date2);
    }

    public static long subYears(Date date1, Date date2) {
        return Math.abs(DateUtils.getYear(date1) - DateUtils.getYear(date2));
    }

    public static Date formatToStartOfDay(Date date) {
        try {
            SimpleDateFormat dateFormat = DateUtils.buildDateFormat(DEFAULT_DATE_SIMPLE_PATTERN);
            String formattedDate = dateFormat.format(date);
            return dateFormat.parse(formattedDate);
        }
        catch (ParseException pe) {
            throw new DateException("Unparseable date specified.", pe);
        }
    }

    public static Date formatToEndOfDay(Date date) {
        return DateUtils.getDateOfSecondsBack(1, DateUtils.getDateOfDaysBack(-1, DateUtils.formatToStartOfDay(date)));
    }

    public static String format2String(LocalDateTime time) {
        return DateUtils.format2String(Timestamp.valueOf(time), null);
    }

    public static String format2String(Timestamp ts, String fmt) {
        if (ts == null) {
            return null;
        }
        if (fmt == null) {
            fmt = DEFAULT_DATETIME_24HOUR_PATTERN;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            return sdf.format(ts);
        }
        catch (Exception var3) {
            return null;
        }
    }

    private static SimpleDateFormat buildDateFormat(String pattern) {
        SimpleDateFormat simpleDateFormat = simpleDateFormatCache.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat();
            simpleDateFormatCache.set(simpleDateFormat);
        }
        simpleDateFormat.applyPattern(pattern);
        return simpleDateFormat;
    }

    private static Calendar buildCalendar() {
        Calendar calendar = calendarCache.get();
        if (calendar == null) {
            calendar = GregorianCalendar.getInstance();
            calendarCache.set(calendar);
        }
        return calendar;
    }

    private static Calendar buildCalendar(Date date) {
        Calendar calendar = DateUtils.buildCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private static long subTime(Date date1, Date date2, long granularity) {
        long time1 = date1.getTime();
        long time = date2.getTime();
        long subTime = Math.abs(time1 - time);
        return subTime / granularity;
    }

    private static int getNumberOfGranularity(int granularity, Date date) {
        Calendar calendar = DateUtils.buildCalendar(date);
        return calendar.get(granularity);
    }

    private static long getTimeBackInMillis(int granularity, int numberToBack, Date date) {
        Calendar calendar = DateUtils.buildCalendar(date);
        calendar.add(granularity, -numberToBack);
        return calendar.getTimeInMillis();
    }

    private static Date dateBack(int granularity, int numberToBack, Date date) {
        long timeBackInMillis = DateUtils.getTimeBackInMillis(granularity, numberToBack, date);
        return DateUtils.buildDate(timeBackInMillis);
    }

    public static Timestamp getTimestamp(String dateStr) {
        if (StringUtils.isNotBlank((CharSequence)dateStr) && dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            return DateUtils.getTimestamp(dateStr, DEFAULT_DATE_SIMPLE_PATTERN);
        }
        return DateUtils.getTimestamp(dateStr, DEFAULT_DATETIME_24HOUR_PATTERN);
    }

    public static Timestamp getTimestamp(String dateStr, String dateFmt) {
        Timestamp timestamp = null;
        SimpleDateFormat f = new SimpleDateFormat(dateFmt);
        try {
            timestamp = new Timestamp(f.parse(dateStr).getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }
}

