/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static final String EMAIL_REG = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
    public static final String MOBILE_REG = "^((14[0-9])|(13[0-9])|(17[0-9])|(15[^4,\\D])|(18[0-9]))\\d{8}$";
    public static final String TEL_REG = "(^(\\d{3,4}-)?\\d{7,8})$";
    private static final String NEW_MOBILE_REG = "^1\\d{10}$";
    private static DecimalFormat df1 = new DecimalFormat("#.##");
    private static DecimalFormat ONE_DECEMAL_PLACES_FORMAT = new DecimalFormat("#.#");
    private static String MAX_INT_STRING = Integer.toString(Integer.MAX_VALUE);
    private static String MIN_INT_STRING = Integer.toString(Integer.MIN_VALUE);
    private static String MAX_LONG_STRING = Long.toString(Long.MAX_VALUE);
    private static String MIN_LONG_STRING = Long.toString(Long.MIN_VALUE);

    private StringUtil() {
    }

    public static boolean isNullOrEmpty(String string) {
        return null == string || string.length() == 0;
    }

    public static boolean isInteger(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return false;
        }
        char f = string.charAt(0);
        if (f == '-') {
            int n;
            if (string.length() > MIN_INT_STRING.length()) {
                return false;
            }
            for (n = 1; n < string.length(); ++n) {
                if (StringUtil.isNumberChar(string.charAt(n))) continue;
                return false;
            }
            if (string.length() < MIN_INT_STRING.length()) {
                return true;
            }
            for (n = 1; n < string.length(); ++n) {
                char mc = MIN_INT_STRING.charAt(n);
                char sc = string.charAt(n);
                if (sc <= mc) continue;
                return false;
            }
            return true;
        }
        return StringUtil.isPositiveInteger(string);
    }

    public static boolean isPositiveInteger(String string) {
        int n;
        if (StringUtil.isNullOrEmpty(string) || string.length() > MAX_INT_STRING.length()) {
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            if (StringUtil.isNumberChar(string.charAt(n))) continue;
            return false;
        }
        if (string.length() < MAX_INT_STRING.length()) {
            return true;
        }
        for (n = 0; n < string.length(); ++n) {
            char mc = MAX_INT_STRING.charAt(n);
            char sc = string.charAt(n);
            if (sc <= mc) continue;
            return false;
        }
        return true;
    }

    public static boolean isLong(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return false;
        }
        char f = string.charAt(0);
        if (f == '-') {
            int n;
            if (string.length() > MIN_LONG_STRING.length()) {
                return false;
            }
            for (n = 1; n < string.length(); ++n) {
                if (StringUtil.isNumberChar(string.charAt(n))) continue;
                return false;
            }
            if (string.length() < MIN_LONG_STRING.length()) {
                return true;
            }
            for (n = 1; n < string.length(); ++n) {
                char mc = MIN_LONG_STRING.charAt(n);
                char sc = string.charAt(n);
                if (sc <= mc) continue;
                return false;
            }
            return true;
        }
        return StringUtil.isPositiveLong(string);
    }

    public static boolean isPositiveLong(String string) {
        int n;
        if (StringUtil.isNullOrEmpty(string) || string.length() > MAX_LONG_STRING.length()) {
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            if (StringUtil.isNumberChar(string.charAt(n))) continue;
            return false;
        }
        if (string.length() < MAX_LONG_STRING.length()) {
            return true;
        }
        for (n = 0; n < string.length(); ++n) {
            char mc = MAX_LONG_STRING.charAt(n);
            char sc = string.charAt(n);
            if (sc <= mc) continue;
            return false;
        }
        return true;
    }

    public static boolean isDouble(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return false;
        }
        int n = 0;
        if (str.charAt(0) == '-') {
            ++n;
        }
        int pSize = 0;
        boolean p = false;
        while (n < str.length()) {
            char c = str.charAt(n);
            if (c == '.') {
                if (p) {
                    return false;
                }
                p = true;
            } else {
                if (!StringUtil.isNumberChar(c)) {
                    return false;
                }
                if (!p) {
                    ++pSize;
                }
            }
            ++n;
        }
        return pSize > 0;
    }

    public static boolean isNumberChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUppercase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static boolean isSpecialChar(char c) {
        return !StringUtil.isLetter(c) && !StringUtil.isNumberChar(c) && !StringUtil.isChinese(c);
    }

    public static boolean isTimeMinutesFormat(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return false;
        }
        String[] split = str.split(":");
        if (split.length != 2) {
            return false;
        }
        String hourStr = split[0];
        String minuStr = split[1];
        if (!StringUtil.isPositiveInteger(hourStr) || !StringUtil.isPositiveInteger(minuStr)) {
            return false;
        }
        int hour = Integer.parseInt(hourStr);
        int minu = Integer.parseInt(minuStr);
        return hour >= 0 && hour <= 23 && minu >= 0 && minu <= 59;
    }

    public static boolean isMobilePhoneNumber(String str) {
        return !StringUtil.isNullOrEmpty(str) && str.length() == 11 && StringUtil.isPositiveLong(str) && str.charAt(0) == '1';
    }

    public static List<String> getAllRealNumberFromString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isNullOrEmpty(str)) {
            return list;
        }
        StringBuffer buffer = new StringBuffer();
        for (int n = 0; n < str.length(); ++n) {
            char c = str.charAt(n);
            if (StringUtil.isNumberChar(c)) {
                buffer.append(c);
                continue;
            }
            if (c == '.') {
                if (buffer.length() == 0) continue;
                buffer.append(c);
                continue;
            }
            if (c == '-' && buffer.length() == 0) {
                buffer.append(c);
                continue;
            }
            StringUtil.addStrBuffNumberToList(buffer.toString(), list);
            buffer.delete(0, buffer.length());
        }
        StringUtil.addStrBuffNumberToList(buffer.toString(), list);
        return list;
    }

    private static void addStrBuffNumberToList(String strBuff, List<String> strList) {
        if (strBuff == null || strBuff.length() == 0) {
            return;
        }
        if (StringUtil.isDouble(strBuff)) {
            strList.add(strBuff);
        } else {
            String[] strs;
            for (String strItem : strs = strBuff.split("\\.")) {
                if (!StringUtil.isDouble(strItem)) continue;
                strList.add(strItem);
            }
        }
    }

    public static String getFirstRealNumberFromString(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int n = 0; n < str.length(); ++n) {
            char c = str.charAt(n);
            if (StringUtil.isNumberChar(c)) {
                buffer.append(c);
                continue;
            }
            if (c == '.') {
                if (buffer.length() == 0) continue;
                buffer.append(c);
                continue;
            }
            if (c == '-' && buffer.length() == 0) {
                buffer.append(c);
                continue;
            }
            String numstr = StringUtil.getStrBuffNumberFirst(buffer.toString());
            if (numstr != null) {
                return numstr;
            }
            buffer.delete(0, buffer.length());
        }
        String numstr = StringUtil.getStrBuffNumberFirst(buffer.toString());
        if (numstr != null) {
            return numstr;
        }
        return null;
    }

    private static String getStrBuffNumberFirst(String strBuff) {
        String[] strs;
        if (strBuff == null || strBuff.length() == 0) {
            return null;
        }
        if (StringUtil.isDouble(strBuff)) {
            return strBuff;
        }
        for (String strItem : strs = strBuff.split("\\.")) {
            if (!StringUtil.isDouble(strItem)) continue;
            return strItem;
        }
        return null;
    }

    public static String toSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static boolean containsChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ic = str.charAt(i);
            if (!StringUtil.isChinese(ic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ic = str.charAt(i);
            if (StringUtil.isChinese(ic)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetters(String letters) {
        if (StringUtil.isNullOrEmpty(letters)) {
            return false;
        }
        for (int n = 0; n < letters.length(); ++n) {
            char c = letters.charAt(n);
            if (StringUtil.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static String[] stringToArray(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        int count = st.countTokens();
        String[] strArr = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            strArr[i++] = st.nextToken();
        }
        return strArr;
    }

    public static String arrayToString(String[] array, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delim + array[i]);
                continue;
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static List<Integer> strToIntArray(String source) {
        String[] arr;
        ArrayList<Integer> result = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{source}) && (arr = source.split(",")) != null && arr.length > 0) {
            result = new ArrayList<Integer>();
            for (String s : arr) {
                result.add(Integer.valueOf(s));
            }
        }
        return result;
    }

    public static long ipToLong(String ip) {
        long result = 0L;
        String[] ip_feild = ip.split("\\.");
        try {
            for (int i = 0; i < ip_feild.length; ++i) {
                result += Long.parseLong(ip_feild[i]) << 8 * (3 - i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String encodedByMD5(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return StringUtil.byte2string(md.digest());
        }
        catch (Exception e) {
            return password;
        }
    }

    public static String encodedBySHA1(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(source.getBytes());
            return StringUtil.byte2string(md.digest());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64Encode(String s) {
        try {
            return Base64.encodeBase64String((byte[])s.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String base64Encode(byte[] b) {
        return Base64.encodeBase64String((byte[])b);
    }

    public static String base64Decode(String s) {
        try {
            return new String(Base64.decodeBase64((String)s), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] base64DecodeB(String s) {
        return Base64.decodeBase64((String)s);
    }

    public static String encodedUrl(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String byte2string(byte[] b) {
        StringBuffer hs = new StringBuffer(100);
        for (int n = 0; n < b.length; ++n) {
            hs.append(StringUtil.byte2fex(b[n]));
        }
        return hs.toString();
    }

    public static String byte2fex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean isMobile(String mobile) {
        return StringUtils.isNotBlank((CharSequence)mobile) && mobile.matches(NEW_MOBILE_REG);
    }

    public static boolean isTelValid(String tel) {
        return StringUtils.trimToEmpty((String)tel).matches(TEL_REG);
    }

    public static String contactWayFormat(String mobile, String tels) {
        if (StringUtils.isBlank((CharSequence)tels) && StringUtils.isBlank((CharSequence)mobile)) {
            return "";
        }
        String result = StringUtils.isBlank((CharSequence)mobile) ? "" : mobile + ",";
        String string = tels = StringUtils.isBlank((CharSequence)tels) ? "" : tels;
        if (StringUtils.contains((CharSequence)tels, (CharSequence)mobile)) {
            tels = StringUtils.remove((String)tels, (String)mobile);
        }
        result = result + tels;
        if ((result = result.replaceAll("(,)+", ",")).endsWith(",")) {
            result = StringUtils.substring((String)result, (int)0, (int)(result.length() - 1));
        }
        return result;
    }

    public static String userIdToInvitationCode(int userId) {
        return StringUtils.reverse((String)Integer.toString(userId, 36)).toUpperCase();
    }

    public static String formatPriceToYun(double value) {
        return df1.format(value / 100.0);
    }

    public static String formatPriceToYuanWithFen(long value) {
        long fen = value % 100L;
        return value / 100L + "." + (fen < 10L ? "0" + fen : Long.valueOf(fen));
    }

    public static Long formatPriceToFen(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Double doubleValue = null;
        try {
            doubleValue = Double.valueOf(value) * 100.0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return doubleValue == null ? null : Long.valueOf(doubleValue.longValue());
    }

    public static int getByteLength(String s) {
        if (s == null) {
            return 0;
        }
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    public static void blankFill(String[] chars, String fill) {
        if (chars == null || chars.length == 0) {
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (!StringUtils.isBlank((CharSequence)chars[i])) continue;
            chars[i] = fill;
        }
    }

    public static String filterInvalidChars(String str, String regex) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        String content = new String(str);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        String result = m.replaceAll("");
        return result;
    }

    public static String mist(String conent) {
        if (StringUtils.isBlank((CharSequence)conent)) {
            return "*";
        }
        String mistedStr = String.valueOf(conent.charAt(0));
        mistedStr = mistedStr + (conent.length() > 3 ? "**" + conent.charAt(conent.length() - 1) : (conent.length() > 2 ? "*" + conent.charAt(conent.length() - 1) : "*"));
        return mistedStr;
    }

    public static String getDiscountChars(Integer currentPrice, Integer originalPrice) {
        return StringUtil.discount(currentPrice, originalPrice) + "\u6298";
    }

    public static double discount(Integer currentPrice, Integer originalPrice) {
        if (originalPrice == null || originalPrice == 0 || currentPrice == null || currentPrice == 0) {
            return 0.0;
        }
        return Double.valueOf(ONE_DECEMAL_PLACES_FORMAT.format(currentPrice.doubleValue() / originalPrice.doubleValue() * 10.0));
    }

    public static String patternMatcherStr(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',//[//].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isEmail(String str) {
        return StringUtils.isNotBlank((CharSequence)str) && str.matches(EMAIL_REG);
    }

    public static String getVersionTs() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String ts = format.format(new Date());
        return ts;
    }

    public static String hump2Underline(String str) {
        String regex = "([a-z])([A-Z])";
        String replacement = "$1_$2";
        return str.replaceAll(regex, replacement).toLowerCase();
    }
}

