/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils.text;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CsvUtils {
    public static List<String[]> read(File file) {
        String cvsSplitBy = ",";
        ArrayList result = Lists.newArrayList();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line.split(cvsSplitBy));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void write(List<String[]> data, File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            CsvUtils.write(data, fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(List<String[]> data, OutputStream os) {
        byte[] commonCsvHead = new byte[]{-17, -69, -65};
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, "UTF-8");
            PrintWriter fileWriter = new PrintWriter(outputStreamWriter);
            fileWriter.write(new String(commonCsvHead));
            for (Object[] objectArray : data) {
                fileWriter.write(StringUtils.join((Object[])objectArray, (String)","));
                fileWriter.write("\n");
                fileWriter.flush();
            }
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

