package com.ec.primus.commons.enums.converter;

import com.ec.primus.commons.enums.ValuableAndDescribableEnum;

import javax.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

/**
 * 枚举covert
 *@author ning.zhang
 *@date 2019/9/9
 */
public abstract class BaseEnumValueAndDescriptionConverter<T extends ValuableAndDescribableEnum>
        implements AttributeConverter<ValuableAndDescribableEnum, Integer> {
    private Class<T> tClass = null;

    private Class<T> getTargetClass() {
        if (this.tClass == null) {
            Type[] actualTypeArguments = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments();
            this.tClass = ((actualTypeArguments == null) || (actualTypeArguments.length == 0) ? null : (Class) actualTypeArguments[0]);
        }

        return this.tClass;
    }

    @Override
    public Integer convertToDatabaseColumn(ValuableAndDescribableEnum attribute) {
        return attribute == null ? null : attribute.getValue();
    }


    @Override
    public T convertToEntityAttribute(Integer dbData) {
        Class<? extends ValuableAndDescribableEnum> fieldClass = getTargetClass();
        if ((fieldClass == null) || (!fieldClass.isEnum())) {
            return null;
        }
        for (ValuableAndDescribableEnum enumConstant : (ValuableAndDescribableEnum[]) fieldClass.getEnumConstants()) {
            if (Objects.equals(enumConstant.getValue(), dbData)) {
                return (T) enumConstant;
            }
        }
        return null;
    }
}